/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml.v311;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlType;
import org.opengis.coverage.grid.GridCoordinates;
import org.opengis.coverage.grid.GridEnvelope;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="GridEnvelopeType", propOrder={"low", "high"})
public class GridEnvelopeType
implements GridEnvelope {
    @XmlList
    @XmlElement(required=true)
    private int[] low;
    @XmlList
    @XmlElement(required=true)
    private int[] high;

    GridEnvelopeType() {
    }

    public GridEnvelopeType(GridEnvelope env) {
        if (env != null) {
            if (env.getHigh() != null) {
                this.high = env.getHigh().getCoordinateValues();
            }
            if (env.getLow() != null) {
                this.low = env.getLow().getCoordinateValues();
            }
        }
    }

    public GridEnvelopeType(int[] low, int[] high) {
        this.high = high;
        this.low = low;
    }

    @Override
    public GridCoordinates getLow() {
        if (this.low != null) {
            return new GmlGridCoordinates(this.low);
        }
        return null;
    }

    @Override
    public GridCoordinates getHigh() {
        if (this.high != null) {
            return new GmlGridCoordinates(this.high);
        }
        return null;
    }

    @Override
    public int getDimension() {
        if (this.low != null) {
            return this.low.length;
        }
        return 0;
    }

    @Override
    public int getLow(int i) throws IndexOutOfBoundsException {
        if (this.low != null && i < this.low.length) {
            return this.low[i];
        }
        return -1;
    }

    @Override
    public int getHigh(int i) throws IndexOutOfBoundsException {
        if (this.high != null && i < this.high.length) {
            return this.high[i];
        }
        return -1;
    }

    @Override
    public int getSpan(int i) throws IndexOutOfBoundsException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public class GmlGridCoordinates
    implements GridCoordinates {
        final int[] coordinates;

        public GmlGridCoordinates(int[] coordinates) {
            this.coordinates = (int[])coordinates.clone();
        }

        @Override
        public int getDimension() {
            if (this.coordinates != null) {
                return this.coordinates.length;
            }
            return -1;
        }

        @Override
        public int[] getCoordinateValues() {
            if (this.coordinates != null) {
                return (int[])this.coordinates.clone();
            }
            return null;
        }

        @Override
        public int getCoordinateValue(int dimension) throws IndexOutOfBoundsException {
            if (this.coordinates != null) {
                return this.coordinates[dimension];
            }
            return -1;
        }

        @Override
        public void setCoordinateValue(int dimension, int value) throws IndexOutOfBoundsException, UnsupportedOperationException {
            if (this.coordinates != null) {
                this.coordinates[dimension] = value;
            }
        }
    }
}

