/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.jaxb.referencing;

import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.xml.bind.annotation.XmlElement;
import org.geotoolkit.factory.FactoryNotFoundException;
import org.geotoolkit.internal.TemporalUtilities;
import org.geotoolkit.internal.jaxb.XmlUtilities;
import org.geotoolkit.internal.jaxb.gco.PropertyType;
import org.geotoolkit.internal.jaxb.referencing.TimeInstant;
import org.geotoolkit.internal.jaxb.referencing.TimePeriod;
import org.geotoolkit.internal.jaxb.referencing.TimePeriodBound;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.logging.Logging;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Period;
import org.opengis.temporal.TemporalPrimitive;

public final class TM_Primitive
extends PropertyType<TM_Primitive, TemporalPrimitive> {
    public TM_Primitive() {
    }

    private TM_Primitive(TemporalPrimitive temporalPrimitive) {
        super(temporalPrimitive);
    }

    @Override
    protected TM_Primitive wrap(TemporalPrimitive temporalPrimitive) {
        return new TM_Primitive(temporalPrimitive);
    }

    @Override
    protected Class<TemporalPrimitive> getBoundType() {
        return TemporalPrimitive.class;
    }

    @Override
    @XmlElement(name="TimePeriod")
    public TimePeriod getElement() {
        TemporalPrimitive temporalPrimitive;
        if (!this.skip() && (temporalPrimitive = (TemporalPrimitive)this.metadata) instanceof Period) {
            return new TimePeriod((Period)temporalPrimitive);
        }
        return null;
    }

    @XmlElement(name="TimeInstant")
    public TimeInstant getInstant() {
        TemporalPrimitive temporalPrimitive;
        if (!this.skip() && (temporalPrimitive = (TemporalPrimitive)this.metadata) instanceof Instant) {
            return new TimeInstant((Instant)temporalPrimitive);
        }
        return null;
    }

    public void setElement(TimePeriod timePeriod) {
        this.metadata = null;
        if (timePeriod != null) {
            Date date = TM_Primitive.toDate(timePeriod.begin);
            Date date2 = TM_Primitive.toDate(timePeriod.end);
            if (date != null || date2 != null) {
                LogRecord logRecord;
                if (date != null && date2 != null && date2.before(date)) {
                    logRecord = Errors.getResources(null).getLogRecord(Level.WARNING, 14, date, date2);
                } else {
                    try {
                        this.metadata = TemporalUtilities.createPeriod(date, date2);
                        timePeriod.copyIdTo(this.metadata);
                        return;
                    }
                    catch (FactoryNotFoundException factoryNotFoundException) {
                        logRecord = TemporalUtilities.createLog(factoryNotFoundException);
                    }
                }
                TM_Primitive.log(TemporalPrimitive.class, "setTimePeriod", logRecord);
            }
        }
    }

    public void setInstant(TimeInstant timeInstant) {
        Date date;
        this.metadata = null;
        if (timeInstant != null && (date = XmlUtilities.toDate(timeInstant.timePosition)) != null) {
            try {
                this.metadata = TemporalUtilities.createInstant(date);
                timeInstant.copyIdTo(this.metadata);
            }
            catch (FactoryNotFoundException factoryNotFoundException) {
                TM_Primitive.log(TemporalPrimitive.class, "setTimeInstant", TemporalUtilities.createLog(factoryNotFoundException));
            }
        }
    }

    private static Date toDate(TimePeriodBound timePeriodBound) {
        return timePeriodBound != null ? XmlUtilities.toDate(timePeriodBound.calendar()) : null;
    }

    public static void log(Class<?> clazz, String string, LogRecord logRecord) {
        logRecord.setSourceClassName(clazz.getName());
        logRecord.setSourceMethodName(string);
        logRecord.setLoggerName("org.geotoolkit.xml");
        Logging.getLogger("org.geotoolkit.xml").log(logRecord);
    }
}

