/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.geotoolkit.metadata.KeyNamePolicy;
import org.geotoolkit.metadata.MetadataMap;
import org.geotoolkit.metadata.PropertyAccessor;
import org.geotoolkit.metadata.TypeValuePolicy;

final class TypeMap
extends MetadataMap<Class<?>> {
    final TypeValuePolicy types;

    TypeMap(PropertyAccessor propertyAccessor, TypeValuePolicy typeValuePolicy, KeyNamePolicy keyNamePolicy) {
        super(propertyAccessor, keyNamePolicy);
        this.types = typeValuePolicy;
    }

    @Override
    public int size() {
        return this.accessor.count();
    }

    @Override
    public boolean containsKey(Object object) {
        return object instanceof String && this.accessor.indexOf((String)object) >= 0;
    }

    @Override
    public Class<?> get(Object object) {
        if (object instanceof String) {
            int n = this.accessor.indexOf((String)object);
            return n >= 0 ? this.accessor.type(n, this.types) : null;
        }
        return null;
    }

    @Override
    final Iterator<Map.Entry<String, Class<?>>> iterator() {
        return new Iter();
    }

    private final class Iter
    extends MetadataMap.Iter {
        private int next;

        Iter() {
        }

        @Override
        public boolean hasNext() {
            return this.next < TypeMap.this.accessor.count();
        }

        @Override
        public Map.Entry<String, Class<?>> next() {
            int n;
            PropertyAccessor propertyAccessor = TypeMap.this.accessor;
            if ((n = this.next++) >= propertyAccessor.count()) {
                throw new NoSuchElementException();
            }
            return new AbstractMap.SimpleEntry(propertyAccessor.name(n, TypeMap.this.keyNames), propertyAccessor.type(n, TypeMap.this.types));
        }
    }
}

