/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.datum;

import java.util.Collections;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.jaxb.MarshalContext;
import org.geotoolkit.internal.referencing.NilReferencingObject;
import org.geotoolkit.internal.referencing.VerticalDatumTypes;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.referencing.datum.AbstractDatum;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Strings;
import org.geotoolkit.util.Utilities;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;

@Immutable
@XmlType(name="VerticalDatumType")
@XmlRootElement(name="VerticalDatum")
public class DefaultVerticalDatum
extends AbstractDatum
implements VerticalDatum {
    private static final long serialVersionUID = 380347456670516572L;
    private static final VerticalDatumType[] TYPES = VerticalDatumTypes.values();
    private static final short[] LEGACY_CODES = new short[TYPES.length];
    private VerticalDatumType type;
    public static final DefaultVerticalDatum BAROMETRIC;
    public static final DefaultVerticalDatum GEOIDAL;
    public static final DefaultVerticalDatum ELLIPSOIDAL;
    public static final DefaultVerticalDatum OTHER_SURFACE;

    private DefaultVerticalDatum() {
        super(NilReferencingObject.INSTANCE);
    }

    public DefaultVerticalDatum(String string, VerticalDatumType verticalDatumType) {
        this(Collections.singletonMap("name", string), verticalDatumType);
    }

    public DefaultVerticalDatum(VerticalDatum verticalDatum) {
        super(verticalDatum);
        this.type = verticalDatum.getVerticalDatumType();
    }

    public DefaultVerticalDatum(Map<String, ?> map, VerticalDatumType verticalDatumType) {
        super(map);
        this.type = verticalDatumType;
        ArgumentChecks.ensureNonNull("type", verticalDatumType);
    }

    public static DefaultVerticalDatum castOrCopy(VerticalDatum verticalDatum) {
        return verticalDatum == null || verticalDatum instanceof DefaultVerticalDatum ? (DefaultVerticalDatum)verticalDatum : new DefaultVerticalDatum(verticalDatum);
    }

    private static boolean find(StringBuilder stringBuilder, String string) {
        int n = stringBuilder.indexOf(string);
        return n == 0 || n >= 0 && Character.isWhitespace(stringBuilder.charAt(n - 1));
    }

    private VerticalDatumType type() {
        VerticalDatumType verticalDatumType = this.type;
        if (verticalDatumType == null) {
            verticalDatumType = VerticalDatumTypes.ELLIPSOIDAL;
            String string = this.getName(null);
            if (string != null) {
                StringBuilder stringBuilder = new StringBuilder(string);
                Strings.toASCII(stringBuilder);
                int n = stringBuilder.length();
                while (--n >= 0) {
                    stringBuilder.setCharAt(n, Character.toLowerCase(stringBuilder.charAt(n)));
                }
                if (DefaultVerticalDatum.find(stringBuilder, "depth")) {
                    verticalDatumType = VerticalDatumType.DEPTH;
                } else if (DefaultVerticalDatum.find(stringBuilder, "geoid")) {
                    verticalDatumType = VerticalDatumType.GEOIDAL;
                } else if (DefaultVerticalDatum.find(stringBuilder, "barometric")) {
                    verticalDatumType = VerticalDatumType.BAROMETRIC;
                }
            }
            this.type = verticalDatumType;
        }
        return verticalDatumType;
    }

    @Override
    public VerticalDatumType getVerticalDatumType() {
        return this.type();
    }

    @XmlElement(name="verticalDatumType")
    private VerticalDatumType getMarshalled() {
        return MarshalContext.versionGML(MarshalContext.GML_3_2) ? null : this.getVerticalDatumType();
    }

    private void setMarshalled(VerticalDatumType verticalDatumType) {
        if (this.type != null) {
            throw new IllegalStateException();
        }
        this.type = verticalDatumType;
    }

    @Override
    final int getLegacyDatumType() {
        VerticalDatumType verticalDatumType = this.getVerticalDatumType();
        int n = verticalDatumType.ordinal();
        if (n >= 0 && n < LEGACY_CODES.length) {
            assert (verticalDatumType.equals(TYPES[n])) : verticalDatumType;
            return LEGACY_CODES[n];
        }
        return 0;
    }

    public static VerticalDatumType getVerticalDatumTypeFromLegacyCode(int n) {
        for (int i = 0; i < LEGACY_CODES.length; ++i) {
            if (LEGACY_CODES[i] != n) continue;
            return TYPES[i];
        }
        return null;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            switch (comparisonMode) {
                case STRICT: {
                    DefaultVerticalDatum defaultVerticalDatum = (DefaultVerticalDatum)object;
                    return Utilities.equals(this.type(), defaultVerticalDatum.type());
                }
            }
            VerticalDatum verticalDatum = (VerticalDatum)object;
            return Utilities.equals(this.getVerticalDatumType(), verticalDatum.getVerticalDatumType());
        }
        return false;
    }

    @Override
    protected int computeHashCode() {
        return Utilities.hash(this.type(), super.computeHashCode());
    }

    @Override
    public String formatWKT(Formatter formatter) {
        super.formatWKT(formatter);
        return "VERT_DATUM";
    }

    static {
        DefaultVerticalDatum.LEGACY_CODES[VerticalDatumType.GEOIDAL.ordinal()] = 2005;
        DefaultVerticalDatum.LEGACY_CODES[VerticalDatumTypes.ELLIPSOIDAL.ordinal()] = 2002;
        DefaultVerticalDatum.LEGACY_CODES[VerticalDatumType.DEPTH.ordinal()] = 2006;
        DefaultVerticalDatum.LEGACY_CODES[VerticalDatumType.BAROMETRIC.ordinal()] = 2003;
        DefaultVerticalDatum.LEGACY_CODES[VerticalDatumTypes.ORTHOMETRIC.ordinal()] = 2001;
        DefaultVerticalDatum.LEGACY_CODES[VerticalDatumType.OTHER_SURFACE.ordinal()] = 2000;
        BAROMETRIC = new DefaultVerticalDatum(DefaultVerticalDatum.name(18), VerticalDatumType.BAROMETRIC);
        GEOIDAL = new DefaultVerticalDatum(DefaultVerticalDatum.name(126), VerticalDatumType.GEOIDAL);
        ELLIPSOIDAL = new DefaultVerticalDatum(DefaultVerticalDatum.name(91), VerticalDatumTypes.ELLIPSOIDAL);
        OTHER_SURFACE = new DefaultVerticalDatum(DefaultVerticalDatum.name(223), VerticalDatumType.OTHER_SURFACE);
    }
}

