/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory.web;

import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.factory.Factory;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.factory.AbstractAuthorityFactory;
import org.geotoolkit.referencing.factory.AllAuthoritiesFactory;
import org.geotoolkit.referencing.factory.AuthorityFactoryAdapter;
import org.geotoolkit.referencing.factory.IdentifiedObjectFinder;
import org.geotoolkit.referencing.factory.web.FinderAdapter;
import org.geotoolkit.resources.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.util.FactoryException;

@ThreadSafe
public class HTTP_AuthorityFactory
extends AuthorityFactoryAdapter
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory,
CoordinateOperationAuthorityFactory {
    public static final String BASE_URL = "http://www.opengis.net/gml/srs/";
    private final AllAuthoritiesFactory factory;

    public HTTP_AuthorityFactory() {
        this(EMPTY_HINTS);
    }

    public HTTP_AuthorityFactory(Hints hints) {
        this(AllAuthoritiesFactory.getInstance(HTTP_AuthorityFactory.removeIgnoredHints(hints, "http")));
    }

    public HTTP_AuthorityFactory(AllAuthoritiesFactory allAuthoritiesFactory) {
        super((AuthorityFactory)allAuthoritiesFactory);
        this.factory = allAuthoritiesFactory;
    }

    static Hints removeIgnoredHints(Hints hints, String string) {
        if (!HTTP_AuthorityFactory.forceAxisOrderHonoring(hints, string)) {
            hints = (hints != null ? hints : EMPTY_HINTS).clone();
            hints.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.FALSE);
        }
        return hints;
    }

    static boolean forceAxisOrderHonoring(Hints hints, String string) {
        Object object = null;
        if (hints != null) {
            object = hints.get(Hints.FORCE_AXIS_ORDER_HONORING);
        }
        if (object instanceof CharSequence) {
            String string2 = object.toString();
            int n = 0;
            while ((n = string2.indexOf(string, n)) >= 0) {
                int n2;
                if (!(n != 0 && Character.isJavaIdentifierPart(string2.charAt(n - 1)) || (n2 = n + string.length()) != string2.length() && Character.isJavaIdentifierPart(string2.charAt(n2)))) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    @Override
    public Citation getAuthority() {
        return Citations.HTTP_OGC;
    }

    @Override
    protected String toBackingFactoryCode(String string) throws FactoryException {
        int n;
        int n2;
        String string2 = string.trim();
        if (string2.regionMatches(true, 0, BASE_URL, 0, n2 = BASE_URL.length()) && (string2 = string2.substring(n2)).indexOf(47) < 0 && (n = string2.indexOf(35)) >= 0 && string2.indexOf(35, n + 1) < 0) {
            String string3 = string2.substring(0, n).trim();
            int n3 = string3.lastIndexOf(46);
            if (n3 > 0) {
                string3 = string3.substring(0, n3);
            }
            string2 = string2.substring(n + 1).trim();
            string2 = string3 + ':' + string2;
            return string2;
        }
        throw new NoSuchAuthorityCodeException(Errors.format(73, "code", string), BASE_URL, string2, string);
    }

    @Override
    public IdentifiedObjectFinder getIdentifiedObjectFinder(Class<? extends IdentifiedObject> clazz) throws FactoryException {
        return new Finder(this.factory, clazz);
    }

    @Override
    protected boolean hasCompatibleHints(Hints hints) {
        return super.hasCompatibleHints(HTTP_AuthorityFactory.removeIgnoredHints(hints, "http"));
    }

    @Override
    protected void setOrdering(Factory.Organizer organizer) {
        super.setOrdering(organizer);
        organizer.after(AbstractAuthorityFactory.class, true);
    }

    private static final class Finder
    extends FinderAdapter {
        Finder(AbstractAuthorityFactory abstractAuthorityFactory, Class<? extends IdentifiedObject> clazz) throws FactoryException {
            super(abstractAuthorityFactory, clazz);
        }

        @Override
        StringBuilder path(IdentifiedObject identifiedObject, ReferenceIdentifier referenceIdentifier, String string) {
            return new StringBuilder(HTTP_AuthorityFactory.BASE_URL).append(string).append(".xml#");
        }
    }
}

