/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.referencing.operation.AbstractCoordinateOperation;
import org.geotoolkit.referencing.operation.MathTransforms;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.UnmodifiableArrayList;
import org.geotoolkit.util.collection.XCollections;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;

@Immutable
public class DefaultConcatenatedOperation
extends AbstractCoordinateOperation
implements ConcatenatedOperation {
    private static final long serialVersionUID = 4199619838029045700L;
    private final List<SingleOperation> operations;

    public DefaultConcatenatedOperation(String string, CoordinateOperation ... coordinateOperationArray) {
        this(Collections.singletonMap("name", string), coordinateOperationArray);
    }

    public DefaultConcatenatedOperation(Map<String, ?> map, CoordinateOperation ... coordinateOperationArray) {
        this(map, new ArrayList<SingleOperation>(coordinateOperationArray.length), coordinateOperationArray);
    }

    public DefaultConcatenatedOperation(Map<String, ?> map, CoordinateOperation[] coordinateOperationArray, MathTransformFactory mathTransformFactory) throws FactoryException {
        this(map, new ArrayList<SingleOperation>(coordinateOperationArray.length), coordinateOperationArray, mathTransformFactory);
    }

    private DefaultConcatenatedOperation(Map<String, ?> map, ArrayList<SingleOperation> arrayList, CoordinateOperation[] coordinateOperationArray) {
        this(map, DefaultConcatenatedOperation.expand(coordinateOperationArray, arrayList), arrayList);
    }

    private DefaultConcatenatedOperation(Map<String, ?> map, ArrayList<SingleOperation> arrayList, CoordinateOperation[] coordinateOperationArray, MathTransformFactory mathTransformFactory) throws FactoryException {
        this(map, DefaultConcatenatedOperation.expand(coordinateOperationArray, arrayList, mathTransformFactory, true), arrayList);
    }

    private DefaultConcatenatedOperation(Map<String, ?> map, MathTransform mathTransform, List<SingleOperation> list) {
        super(DefaultConcatenatedOperation.mergeAccuracy(map, list), list.get(0).getSourceCRS(), list.get(list.size() - 1).getTargetCRS(), mathTransform);
        this.operations = UnmodifiableArrayList.wrap(list.toArray(new SingleOperation[list.size()]));
    }

    private static MathTransform expand(CoordinateOperation[] coordinateOperationArray, List<SingleOperation> list) {
        try {
            return DefaultConcatenatedOperation.expand(coordinateOperationArray, list, null, true);
        }
        catch (FactoryException factoryException) {
            throw new AssertionError((Object)factoryException);
        }
    }

    private static MathTransform expand(CoordinateOperation[] coordinateOperationArray, List<SingleOperation> list, MathTransformFactory mathTransformFactory, boolean bl) throws FactoryException {
        int n;
        Object object = null;
        ArgumentChecks.ensureNonNull("operations", coordinateOperationArray);
        for (n = 0; n < coordinateOperationArray.length; ++n) {
            Object object2;
            Object object3;
            ArgumentChecks.ensureNonNull("operations", n, coordinateOperationArray);
            CoordinateOperation coordinateOperation = coordinateOperationArray[n];
            if (coordinateOperation instanceof SingleOperation) {
                list.add((SingleOperation)coordinateOperation);
            } else if (coordinateOperation instanceof ConcatenatedOperation) {
                object3 = (ConcatenatedOperation)coordinateOperation;
                object2 = object3.getOperations();
                DefaultConcatenatedOperation.expand(object2.toArray(new CoordinateOperation[object2.size()]), list, mathTransformFactory, false);
            } else {
                throw new IllegalArgumentException(Errors.format(76, coordinateOperation.getClass(), SingleOperation.class));
            }
            if (n != 0) {
                int n2;
                int n3;
                object3 = coordinateOperationArray[n - 1].getTargetCRS();
                object2 = coordinateOperation.getSourceCRS();
                if (object3 != null && object2 != null && (n3 = object3.getCoordinateSystem().getDimension()) != (n2 = object2.getCoordinateSystem().getDimension())) {
                    throw new IllegalArgumentException(Errors.format(112, n3, n2));
                }
            }
            if (!bl) continue;
            object3 = coordinateOperation.getMathTransform();
            object = object == null ? object3 : (mathTransformFactory != null ? mathTransformFactory.createConcatenatedTransform((MathTransform)object, (MathTransform)object3) : MathTransforms.concatenate((MathTransform)object, (MathTransform)object3));
        }
        if (bl && (n = list.size()) <= 1) {
            throw new IllegalArgumentException(Errors.format(119, "operations[" + n + ']'));
        }
        return object;
    }

    private static Map<String, ?> mergeAccuracy(Map<String, ?> map, List<? extends CoordinateOperation> list) {
        if (!map.containsKey("coordinateOperationAccuracy")) {
            LinkedHashSet<PositionalAccuracy> linkedHashSet = null;
            for (CoordinateOperation coordinateOperation : list) {
                Collection<PositionalAccuracy> collection;
                if (!(coordinateOperation instanceof Transformation) || XCollections.isNullOrEmpty(collection = coordinateOperation.getCoordinateOperationAccuracy())) continue;
                if (linkedHashSet == null) {
                    linkedHashSet = new LinkedHashSet<PositionalAccuracy>();
                }
                linkedHashSet.addAll(collection);
            }
            if (linkedHashSet != null) {
                HashMap<String, ?> hashMap = new HashMap(map);
                hashMap.put("coordinateOperationAccuracy", linkedHashSet.toArray(new PositionalAccuracy[linkedHashSet.size()]));
                return hashMap;
            }
        }
        return map;
    }

    @Override
    public List<SingleOperation> getOperations() {
        return this.operations;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            switch (comparisonMode) {
                case STRICT: {
                    DefaultConcatenatedOperation defaultConcatenatedOperation = (DefaultConcatenatedOperation)object;
                    return Utilities.equals(this.operations, defaultConcatenatedOperation.operations);
                }
            }
            ConcatenatedOperation concatenatedOperation = (ConcatenatedOperation)object;
            return Utilities.deepEquals(this.getOperations(), concatenatedOperation.getOperations(), comparisonMode);
        }
        return false;
    }

    @Override
    protected int computeHashCode() {
        return Utilities.hash(this.operations, super.computeHashCode());
    }

    @Override
    public String formatWKT(Formatter formatter) {
        String string = super.formatWKT(formatter);
        for (SingleOperation singleOperation : this.operations) {
            formatter.append(singleOperation);
        }
        return string;
    }
}

