/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19136;

import java.util.logging.Level;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.geotoolkit.factory.Hints;
import org.opengis.cite.iso19136.util.TestSuiteLogger;
import org.testng.IExecutionListener;

public class TestRunListener
implements IExecutionListener {
    @Override
    public void onExecutionStart() {
        DataSource dataSource = null;
        try {
            InitialContext initContext = new InitialContext();
            Context envContext = (Context)initContext.lookup("java:/comp/env");
            dataSource = (DataSource)envContext.lookup("jdbc/EPSG");
        }
        catch (NamingException nx) {
            TestSuiteLogger.log(Level.CONFIG, "JNDI DataSource 'jdbc/EPSG' not found. An embedded database will be created if necessary.");
        }
        if (null != dataSource) {
            Hints.putSystemDefault(Hints.EPSG_DATA_SOURCE, dataSource);
        }
    }

    @Override
    public void onExecutionFinish() {
    }
}

