/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19136.components;

import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSTypeDefinition;
import org.opengis.cite.iso19136.ETSAssert;
import org.opengis.cite.iso19136.ErrorMessage;
import org.opengis.cite.iso19136.SuiteAttribute;
import org.opengis.cite.iso19136.general.AppSchemaInfo;
import org.opengis.cite.iso19136.general.SchemaModelFixture;
import org.opengis.cite.iso19136.util.FeatureTypeFilter;
import org.opengis.cite.iso19136.util.XMLSchemaModelUtils;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class FeatureComponentTests
extends SchemaModelFixture {
    @BeforeTest
    public void hasFeatureComponents(ITestContext testContext) {
        if (null == this.model) {
            this.model = (XSModel)testContext.getSuite().getAttribute(SuiteAttribute.XSMODEL.getName());
        }
        Set<XSComplexTypeDefinition> complexTypes = XMLSchemaModelUtils.getReferencedComplexTypeDefinitions(this.model);
        FeatureTypeFilter typeFilter = new FeatureTypeFilter();
        typeFilter.filterSet(complexTypes);
        Assert.assertFalse(complexTypes.isEmpty(), "No GML feature type definitions found in schema.");
        if (null == this.schemaInfo) {
            this.schemaInfo = (AppSchemaInfo)testContext.getSuite().getAttribute(SuiteAttribute.SCHEMA_INFO.getName());
        }
        this.schemaInfo.setFeatureDefinitions(complexTypes);
    }

    @Test(description="See ISO 19136: A.1.1.15")
    public void substitutesForAbstractFeature() {
        List<XSElementDeclaration> gmlFeatures = XMLSchemaModelUtils.getFeatureDeclarations(this.model);
        Set<XSComplexTypeDefinition> featureDefs = this.schemaInfo.getFeatureDefinitions();
        for (XSComplexTypeDefinition typeDef : featureDefs) {
            List<XSElementDeclaration> features = XMLSchemaModelUtils.getGlobalElementsByType(this.model, typeDef);
            for (XSElementDeclaration feature : features) {
                Assert.assertTrue(gmlFeatures.contains(feature), ErrorMessage.format("SubstitutionError", new QName(feature.getNamespace(), feature.getName()), "gml:AbstractFeature"));
            }
        }
    }

    @Test(description="See ISO 19136: 9.9, A.1.1.16")
    public void verifyFeatureMemberProperties() {
        XSTypeDefinition baseType = this.model.getTypeDefinition("AbstractFeatureMemberType", "http://www.opengis.net/gml/3.2");
        List<XSElementDeclaration> memberProps = XMLSchemaModelUtils.getElementDeclarationsByType(this.model, baseType);
        XSElementDeclaration gmlFeature = this.model.getElementDeclaration("AbstractFeature", "http://www.opengis.net/gml/3.2");
        for (XSElementDeclaration memberProp : memberProps) {
            ETSAssert.assertValidPropertyType(this.model, memberProp, gmlFeature);
        }
    }
}

