/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19136.components;

import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSTypeDefinition;
import org.opengis.cite.iso19136.ETSAssert;
import org.opengis.cite.iso19136.ErrorMessage;
import org.opengis.cite.iso19136.SuiteAttribute;
import org.opengis.cite.iso19136.general.SchemaModelFixture;
import org.opengis.cite.iso19136.util.XMLSchemaModelUtils;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TemporalComponentTests
extends SchemaModelFixture {
    private XSTypeDefinition timeBaseType;

    @BeforeTest
    public void hasTemporalComponents(ITestContext testContext) {
        if (null == this.model) {
            this.model = (XSModel)testContext.getSuite().getAttribute(SuiteAttribute.XSMODEL.getName());
        }
        this.timeBaseType = this.model.getTypeDefinition("AbstractTimeObjectType", "http://www.opengis.net/gml/3.2");
        List<XSElementDeclaration> timeElements = XMLSchemaModelUtils.getGlobalElementsByType(this.model, this.timeBaseType);
        XSElementDeclaration abstractTime = this.model.getElementDeclaration("AbstractTimeObject", "http://www.opengis.net/gml/3.2");
        List<XSElementDeclaration> timeProps = XMLSchemaModelUtils.getImplicitProperties(this.model, abstractTime);
        Assert.assertFalse(timeElements.isEmpty() && timeProps.isEmpty(), "No temporal (property) components found in schema.");
    }

    @Test(description="See ISO 19136: 21.6.2.1")
    public void substitutesForAbstractTimeObject() {
        List<XSElementDeclaration> timeElems = XMLSchemaModelUtils.getTimeObjectDeclarations(this.model);
        Set<XSTypeDefinition> timeTypeDefs = XMLSchemaModelUtils.getDerivedTypeDefinitions(this.model, this.timeBaseType, (short)1);
        for (XSTypeDefinition typeDef : timeTypeDefs) {
            List<XSElementDeclaration> timeDecls = XMLSchemaModelUtils.getGlobalElementsByType(this.model, typeDef);
            for (XSElementDeclaration timeDecl : timeDecls) {
                Assert.assertTrue(timeElems.contains(timeDecl), ErrorMessage.format("SubstitutionError", new QName(timeDecl.getNamespace(), timeDecl.getName()), "gml:AbstractTimeObject"));
            }
        }
    }

    @Test(description="See ISO 19136: 9.7, 21.6.2.2, A.1.1.12")
    public void validateImplicitTemporalProperty() {
        XSElementDeclaration temporal = this.model.getElementDeclaration("AbstractTimeObject", "http://www.opengis.net/gml/3.2");
        List<XSElementDeclaration> timeProps = XMLSchemaModelUtils.getImplicitProperties(this.model, temporal);
        for (XSElementDeclaration prop : timeProps) {
            ETSAssert.assertValidPropertyType(this.model, prop, null);
        }
    }
}

