/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19136.data.spatial;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xerces.xs.XSElementDeclaration;
import org.geotoolkit.gml.xml.v321.CurveType;
import org.geotoolkit.xml.MarshallerPool;
import org.opengis.cite.geomatics.gml.GmlUtils;
import org.opengis.cite.iso19136.data.DataFixture;
import org.opengis.cite.iso19136.data.spatial.GeometryAssert;
import org.opengis.cite.iso19136.util.TestSuiteLogger;
import org.opengis.cite.iso19136.util.XMLSchemaModelUtils;
import org.opengis.cite.iso19136.util.XMLUtils;
import org.opengis.util.FactoryException;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CurveTests
extends DataFixture {
    NodeList curveNodes;
    List<QName> curveElems = new ArrayList<QName>();

    @BeforeClass(alwaysRun=true)
    public void findCurves() {
        StreamSource data = new StreamSource(this.dataFile);
        this.curveElems.add(new QName("http://www.opengis.net/gml/3.2", "Curve"));
        if (null != this.model) {
            XSElementDeclaration gmlCurve = this.model.getElementDeclaration("Curve", "http://www.opengis.net/gml/3.2");
            List<XSElementDeclaration> curveDecls = XMLSchemaModelUtils.getElementsByAffiliation(this.model, gmlCurve);
            for (XSElementDeclaration decl : curveDecls) {
                this.curveElems.add(new QName(decl.getNamespace(), decl.getName()));
            }
        }
        HashMap<String, String> namespaceBindings = new HashMap<String, String>();
        String xpath = this.generateXPathExpression(this.curveElems, namespaceBindings);
        try {
            this.curveNodes = (NodeList)XMLUtils.evaluateXPath(data, xpath, namespaceBindings, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        if (this.curveNodes.getLength() == 0) {
            throw new SkipException("No gml:Curve elements were found.");
        }
    }

    @Test(description="See ISO 19136: 9.10, 10.1.3.2; ISO 19107: 6.2.2.17")
    public void curveHasValidCRS() {
        for (int i = 0; i < this.curveNodes.getLength(); ++i) {
            Element geom = (Element)this.curveNodes.item(i);
            GeometryAssert.assertValidCRS(geom);
        }
    }

    @Test(description="See ISO 19136: 10.4.5")
    public void validCurveSegments() throws DOMException, FactoryException {
        Unmarshaller gmlUnmarshaller;
        try {
            MarshallerPool pool = new MarshallerPool("org.geotoolkit.gml.xml.v321");
            gmlUnmarshaller = pool.acquireUnmarshaller();
        }
        catch (JAXBException jxe) {
            throw new RuntimeException(jxe);
        }
        for (int i = 0; i < this.curveNodes.getLength(); ++i) {
            CurveType curve;
            Element curveElem = (Element)this.curveNodes.item(i);
            GmlUtils.findCRSReference(curveElem);
            GeometryAssert.assertAllCurveSegmentsHaveRequiredLength(curveElem);
            GeometryAssert.assertCurveSegmentsAreConnected(curveElem);
            try {
                JAXBElement result = gmlUnmarshaller.unmarshal((Node)curveElem, CurveType.class);
                curve = (CurveType)result.getValue();
            }
            catch (JAXBException e) {
                TestSuiteLogger.log(Level.WARNING, "Failed to unmarshal curve geometry.", (Exception)((Object)e));
                continue;
            }
            int nSegments = curve.getSegments().getJbAbstractCurveSegment().size();
            Assert.assertFalse(nSegments == 0, String.format("%s[@gml:id='%s'] has no curve segments.", curveElem.getLocalName(), curveElem.getAttributeNS("http://www.opengis.net/gml/3.2", "id")));
            GeometryAssert.assertGeometryCoveredByValidArea(curve);
        }
    }
}

