/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19136.data.spatial;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.geotoolkit.gml.xml.v321.DirectPositionType;
import org.geotoolkit.gml.xml.v321.EnvelopeType;
import org.geotoolkit.xml.MarshallerPool;
import org.opengis.cite.iso19136.data.DataFixture;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class EnvelopeTests
extends DataFixture {
    private static final QName GML_ENV = new QName("http://www.opengis.net/gml/3.2", "Envelope");
    List<EnvelopeType> envelopes;

    @BeforeClass(alwaysRun=true)
    public void findEnvelopes() {
        Unmarshaller unmarshaller;
        this.envelopes = new ArrayList<EnvelopeType>();
        try {
            MarshallerPool pool = new MarshallerPool("org.geotoolkit.gml.xml.v321");
            unmarshaller = pool.acquireUnmarshaller();
        }
        catch (JAXBException jxb) {
            throw new RuntimeException(jxb);
        }
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        try (FileInputStream gmlData = new FileInputStream(this.dataFile);){
            XMLStreamReader reader = factory.createXMLStreamReader(gmlData, "UTF-8");
            while (reader.hasNext()) {
                int eventType = reader.next();
                if (eventType != 1 || !reader.getName().equals(GML_ENV)) continue;
                JAXBElement result = (JAXBElement)unmarshaller.unmarshal(reader);
                this.envelopes.add((EnvelopeType)result.getValue());
            }
            reader.close();
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
        Assert.assertFalse(this.envelopes.isEmpty(), "gml:Envelope elements not found.");
    }

    @Test(description="See ISO 19136: 10.1.3.2")
    public void envelopeHasCRSReference() {
        for (int i = 0; i < this.envelopes.size(); ++i) {
            CoordinateReferenceSystem crs = this.envelopes.get(i).getCoordinateReferenceSystem();
            Assert.assertNotNull(crs, String.format("//gml:Envelope[%d] has no CRS reference.", i + 1));
        }
    }

    @Test(description="See ISO 19107: 6.4.3.2, 6.4.3.3")
    public void checkEnvelopePositions() {
        for (int i = 0; i < this.envelopes.size(); ++i) {
            EnvelopeType env = this.envelopes.get(i);
            DirectPositionType lowerCorner = env.getLowerCorner();
            Assert.assertNotNull(lowerCorner, String.format("//gml:Envelope[%d] has no lowerCorner.", i + 1));
            DirectPositionType upperCorner = env.getUpperCorner();
            Assert.assertEquals(lowerCorner.getDimension(), upperCorner.getDimension(), String.format("//gml:Envelope[%d]: dimension of corner positions must be equal.", i + 1));
            if (null != env.getCoordinateReferenceSystem()) {
                Assert.assertEquals(lowerCorner.getDimension(), env.getCoordinateReferenceSystem().getCoordinateSystem().getDimension(), String.format("In //gml:Envelope[%d], dimension of lowerCorner does not match that of CRS.", i + 1));
            }
            for (int j = 0; j < lowerCorner.getDimension(); ++j) {
                Assert.assertTrue(lowerCorner.getOrdinate(j) < upperCorner.getOrdinate(j), String.format("//gml:Envelope[%d]: expected lowerCorner[%2$d] < upperCorner[%2$d] (%3$f < %4$f).", i + 1, j, lowerCorner.getOrdinate(j), upperCorner.getOrdinate(j)));
            }
        }
    }
}

