/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.testng.ITestNGMethod;
import org.testng.annotations.IAnnotation;
import org.testng.annotations.IConfigurationAnnotation;
import org.testng.annotations.IDataProviderAnnotation;
import org.testng.annotations.IExpectedExceptionsAnnotation;
import org.testng.annotations.IFactoryAnnotation;
import org.testng.annotations.IParametersAnnotation;
import org.testng.annotations.ITestAnnotation;
import org.testng.collections.Maps;
import org.testng.internal.TestNGMethod;
import org.testng.internal.Utils;
import org.testng.internal.annotations.ConfigurationAnnotation;
import org.testng.internal.annotations.IAfterClass;
import org.testng.internal.annotations.IAfterGroups;
import org.testng.internal.annotations.IAfterMethod;
import org.testng.internal.annotations.IAfterSuite;
import org.testng.internal.annotations.IAfterTest;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.IBeforeClass;
import org.testng.internal.annotations.IBeforeGroups;
import org.testng.internal.annotations.IBeforeMethod;
import org.testng.internal.annotations.IBeforeSuite;
import org.testng.internal.annotations.IBeforeTest;
import org.testng.xml.XmlTest;

public class AnnotationHelper {
    private static final Class[] ALL_ANNOTATIONS = new Class[]{ITestAnnotation.class, IConfigurationAnnotation.class, IBeforeClass.class, IAfterClass.class, IBeforeMethod.class, IAfterMethod.class, IDataProviderAnnotation.class, IExpectedExceptionsAnnotation.class, IFactoryAnnotation.class, IParametersAnnotation.class, IBeforeSuite.class, IAfterSuite.class, IBeforeTest.class, IAfterTest.class, IBeforeGroups.class, IAfterGroups.class};
    public static final Class[] CONFIGURATION_CLASSES = new Class[]{IConfigurationAnnotation.class, IBeforeSuite.class, IAfterSuite.class, IBeforeTest.class, IAfterTest.class, IBeforeGroups.class, IAfterGroups.class, IBeforeClass.class, IAfterClass.class, IBeforeMethod.class, IAfterMethod.class};

    public static ITestAnnotation findTest(IAnnotationFinder finder, Class<?> cls) {
        return finder.findAnnotation(cls, ITestAnnotation.class);
    }

    public static ITestAnnotation findTest(IAnnotationFinder finder, Method m3) {
        return finder.findAnnotation(m3, ITestAnnotation.class);
    }

    public static ITestAnnotation findTest(IAnnotationFinder finder, ITestNGMethod m3) {
        return finder.findAnnotation(m3, ITestAnnotation.class);
    }

    public static IFactoryAnnotation findFactory(IAnnotationFinder finder, Method m3) {
        return finder.findAnnotation(m3, IFactoryAnnotation.class);
    }

    public static IFactoryAnnotation findFactory(IAnnotationFinder finder, Constructor c) {
        return finder.findAnnotation(c, IFactoryAnnotation.class);
    }

    public static ITestAnnotation findTest(IAnnotationFinder finder, Constructor ctor) {
        return finder.findAnnotation(ctor, ITestAnnotation.class);
    }

    public static IConfigurationAnnotation findConfiguration(IAnnotationFinder finder, Constructor ctor) {
        IConfigurationAnnotation result = finder.findAnnotation(ctor, IConfigurationAnnotation.class);
        if (result == null) {
            IConfigurationAnnotation bs = (IConfigurationAnnotation)((Object)finder.findAnnotation(ctor, IBeforeSuite.class));
            IConfigurationAnnotation as = (IConfigurationAnnotation)((Object)finder.findAnnotation(ctor, IAfterSuite.class));
            IConfigurationAnnotation bt = (IConfigurationAnnotation)((Object)finder.findAnnotation(ctor, IBeforeTest.class));
            IConfigurationAnnotation at = (IConfigurationAnnotation)((Object)finder.findAnnotation(ctor, IAfterTest.class));
            IConfigurationAnnotation bg = (IConfigurationAnnotation)((Object)finder.findAnnotation(ctor, IBeforeGroups.class));
            IConfigurationAnnotation ag = (IConfigurationAnnotation)((Object)finder.findAnnotation(ctor, IAfterGroups.class));
            IConfigurationAnnotation bc = (IConfigurationAnnotation)((Object)finder.findAnnotation(ctor, IBeforeClass.class));
            IConfigurationAnnotation ac = (IConfigurationAnnotation)((Object)finder.findAnnotation(ctor, IAfterClass.class));
            IConfigurationAnnotation bm = (IConfigurationAnnotation)((Object)finder.findAnnotation(ctor, IBeforeMethod.class));
            IConfigurationAnnotation am = (IConfigurationAnnotation)((Object)finder.findAnnotation(ctor, IAfterMethod.class));
            if (bs != null || as != null || bt != null || at != null || bg != null || ag != null || bc != null || ac != null || bm != null || am != null) {
                result = AnnotationHelper.createConfiguration(bs, as, bt, at, bg, ag, bc, ac, bm, am);
            }
        }
        return result;
    }

    public static IConfigurationAnnotation findConfiguration(IAnnotationFinder finder, Method m3) {
        IConfigurationAnnotation result = finder.findAnnotation(m3, IConfigurationAnnotation.class);
        if (result == null) {
            IConfigurationAnnotation bs = (IConfigurationAnnotation)((Object)finder.findAnnotation(m3, IBeforeSuite.class));
            IConfigurationAnnotation as = (IConfigurationAnnotation)((Object)finder.findAnnotation(m3, IAfterSuite.class));
            IConfigurationAnnotation bt = (IConfigurationAnnotation)((Object)finder.findAnnotation(m3, IBeforeTest.class));
            IConfigurationAnnotation at = (IConfigurationAnnotation)((Object)finder.findAnnotation(m3, IAfterTest.class));
            IConfigurationAnnotation bg = (IConfigurationAnnotation)((Object)finder.findAnnotation(m3, IBeforeGroups.class));
            IConfigurationAnnotation ag = (IConfigurationAnnotation)((Object)finder.findAnnotation(m3, IAfterGroups.class));
            IConfigurationAnnotation bc = (IConfigurationAnnotation)((Object)finder.findAnnotation(m3, IBeforeClass.class));
            IConfigurationAnnotation ac = (IConfigurationAnnotation)((Object)finder.findAnnotation(m3, IAfterClass.class));
            IConfigurationAnnotation bm = (IConfigurationAnnotation)((Object)finder.findAnnotation(m3, IBeforeMethod.class));
            IConfigurationAnnotation am = (IConfigurationAnnotation)((Object)finder.findAnnotation(m3, IAfterMethod.class));
            if (bs != null || as != null || bt != null || at != null || bg != null || ag != null || bc != null || ac != null || bm != null || am != null) {
                result = AnnotationHelper.createConfiguration(bs, as, bt, at, bg, ag, bc, ac, bm, am);
            }
        }
        return result;
    }

    private static IConfigurationAnnotation createConfiguration(IConfigurationAnnotation bs, IConfigurationAnnotation as, IConfigurationAnnotation bt, IConfigurationAnnotation at, IConfigurationAnnotation bg, IConfigurationAnnotation ag, IConfigurationAnnotation bc, IConfigurationAnnotation ac, IConfigurationAnnotation bm, IConfigurationAnnotation am) {
        ConfigurationAnnotation result = new ConfigurationAnnotation();
        if (bs != null) {
            result.setBeforeSuite(true);
            AnnotationHelper.finishInitialize(result, bs);
        }
        if (as != null) {
            result.setAfterSuite(true);
            AnnotationHelper.finishInitialize(result, as);
        }
        if (bt != null) {
            result.setBeforeTest(true);
            AnnotationHelper.finishInitialize(result, bt);
        }
        if (at != null) {
            result.setAfterTest(true);
            AnnotationHelper.finishInitialize(result, at);
        }
        if (bg != null) {
            result.setBeforeGroups(bg.getBeforeGroups());
            AnnotationHelper.finishInitialize(result, bg);
        }
        if (ag != null) {
            result.setAfterGroups(ag.getAfterGroups());
            AnnotationHelper.finishInitialize(result, ag);
        }
        if (bc != null) {
            result.setBeforeTestClass(true);
            AnnotationHelper.finishInitialize(result, bc);
        }
        if (ac != null) {
            result.setAfterTestClass(true);
            AnnotationHelper.finishInitialize(result, ac);
        }
        if (bm != null) {
            result.setBeforeTestMethod(true);
            AnnotationHelper.finishInitialize(result, bm);
        }
        if (am != null) {
            result.setAfterTestMethod(true);
            AnnotationHelper.finishInitialize(result, am);
        }
        return result;
    }

    private static void finishInitialize(ConfigurationAnnotation result, IConfigurationAnnotation bs) {
        result.setFakeConfiguration(true);
        result.setAlwaysRun(bs.getAlwaysRun());
        result.setDependsOnGroups(bs.getDependsOnGroups());
        result.setDependsOnMethods(bs.getDependsOnMethods());
        result.setDescription(bs.getDescription());
        result.setEnabled(bs.getEnabled());
        result.setGroups(bs.getGroups());
        result.setInheritGroups(bs.getInheritGroups());
        result.setParameters(bs.getParameters());
        result.setTimeOut(bs.getTimeOut());
    }

    public static Class[] getAllAnnotations() {
        return ALL_ANNOTATIONS;
    }

    public static ITestNGMethod[] findMethodsWithAnnotation(Class<?> rootClass, Class<? extends IAnnotation> annotationClass, IAnnotationFinder annotationFinder, XmlTest xmlTest) {
        Map<String, TestNGMethod> vResult = Maps.newHashMap();
        try {
            vResult = Maps.newHashMap();
            for (Class<?> cls = rootClass; null != cls; cls = cls.getSuperclass()) {
                Method[] methods;
                boolean hasClassAnnotation = AnnotationHelper.isAnnotationPresent(annotationFinder, cls, annotationClass);
                for (Method m3 : methods = cls.getDeclaredMethods()) {
                    boolean hasMethodAnnotation = AnnotationHelper.isAnnotationPresent(annotationFinder, m3, annotationClass);
                    boolean hasTestNGAnnotation = AnnotationHelper.isAnnotationPresent(annotationFinder, m3, IFactoryAnnotation.class) || AnnotationHelper.isAnnotationPresent(annotationFinder, m3, ITestAnnotation.class) || AnnotationHelper.isAnnotationPresent(annotationFinder, m3, CONFIGURATION_CLASSES);
                    boolean isPublic = Modifier.isPublic(m3.getModifiers());
                    boolean isSynthetic = m3.isSynthetic();
                    if ((!isPublic || !hasClassAnnotation || isSynthetic || hasTestNGAnnotation) && !hasMethodAnnotation) continue;
                    if (AnnotationHelper.isAnnotationPresent(annotationFinder, m3, IConfigurationAnnotation.class) && AnnotationHelper.isAnnotationPresent(annotationFinder, cls, ITestAnnotation.class)) {
                        Utils.log("", 3, "Method " + m3 + " has a configuration annotation" + " and a class-level @Test. This method will only be kept as a" + " configuration method.");
                        continue;
                    }
                    if (m3.getReturnType() != Void.TYPE && !xmlTest.getAllowReturnValues().booleanValue()) {
                        Utils.log("", 2, "Method " + m3 + " has a @Test annotation" + " but also a return value:" + " ignoring it. Use <suite allow-return-values=\"true\"> to fix this");
                        continue;
                    }
                    String key = AnnotationHelper.createMethodKey(m3);
                    if (null != vResult.get(key)) continue;
                    TestNGMethod tm = new TestNGMethod(m3, annotationFinder, xmlTest, null);
                    vResult.put(key, tm);
                }
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        ITestNGMethod[] result = vResult.values().toArray(new ITestNGMethod[vResult.size()]);
        return result;
    }

    public static Annotation findAnnotationSuperClasses(Class<?> annotationClass, Class c) {
        while (c != null) {
            Object result = c.getAnnotation(annotationClass);
            if (result != null) {
                return result;
            }
            c = c.getSuperclass();
        }
        return null;
    }

    private static boolean isAnnotationPresent(IAnnotationFinder annotationFinder, Method m3, Class[] annotationClasses) {
        for (Class a : annotationClasses) {
            if (annotationFinder.findAnnotation(m3, a) == null) continue;
            return true;
        }
        return false;
    }

    private static boolean isAnnotationPresent(IAnnotationFinder annotationFinder, Method m3, Class<? extends IAnnotation> annotationClass) {
        return annotationFinder.findAnnotation(m3, annotationClass) != null;
    }

    private static boolean isAnnotationPresent(IAnnotationFinder annotationFinder, Class<?> cls, Class<? extends IAnnotation> annotationClass) {
        return annotationFinder.findAnnotation(cls, annotationClass) != null;
    }

    private static String createMethodKey(Method m3) {
        StringBuffer result = new StringBuffer(m3.getName());
        for (Class<?> paramClass : m3.getParameterTypes()) {
            result.append(' ').append(paramClass.toString());
        }
        return result.toString();
    }
}

