/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.geomatics;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Logger;
import org.geotoolkit.geometry.Envelopes;
import org.geotoolkit.geometry.ImmutableEnvelope;
import org.geotoolkit.geometry.jts.JTS;
import org.geotoolkit.gml.xml.AbstractGeometry;
import org.geotoolkit.gml.xml.AbstractRing;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.GeodeticCalculator;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.opengis.cite.geomatics.gml.CurveCoordinateListFactory;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class GeodesyUtils {
    private static final Logger LOGR = Logger.getLogger(GeodesyUtils.class.getPackage().getName());
    public static final String EPSG_4326 = "urn:ogc:def:crs:EPSG::4326";
    public static final String OGC_CRS84 = "urn:ogc:def:crs:OGC:1.3:CRS84";

    public static ImmutableEnvelope getDomainOfValidity(String crsRef) throws FactoryException {
        Object crs = null;
        crs = crsRef.equals(OGC_CRS84) ? DefaultGeographicCRS.WGS84 : CRS.decode((String)GeodesyUtils.getAbbreviatedCRSIdentifier(crsRef));
        Envelope areaOfUse = Envelopes.getDomainOfValidity((CoordinateReferenceSystem)crs);
        return new ImmutableEnvelope(areaOfUse);
    }

    public static String getCRSIdentifier(CoordinateReferenceSystem crs) {
        Set identifiers = crs.getIdentifiers();
        if (identifiers.isEmpty()) {
            if (crs.getName().getCode().startsWith("WGS84")) {
                return OGC_CRS84;
            }
            return "";
        }
        StringBuilder crsId = new StringBuilder("urn:ogc:def:crs:");
        ReferenceIdentifier id = (ReferenceIdentifier)identifiers.iterator().next();
        crsId.append(id.getCodeSpace()).append(":");
        if (!id.getCodeSpace().equalsIgnoreCase("EPSG")) {
            crsId.append(id.getVersion());
        }
        crsId.append(':');
        crsId.append(id.getCode());
        return crsId.toString();
    }

    public static DirectPosition calculateDestination(Position startingPos, double azimuth, double distance) {
        CoordinateReferenceSystem crs = startingPos.getDirectPosition().getCoordinateReferenceSystem();
        GeodeticCalculator calculator = new GeodeticCalculator(crs);
        DirectPosition destPos = null;
        if (azimuth > 180.0) {
            azimuth -= 360.0;
        } else if (azimuth < -180.0) {
            azimuth += 360.0;
        }
        try {
            calculator.setStartingPosition(startingPos);
            calculator.setDirection(azimuth, distance);
            destPos = calculator.getDestinationPosition();
        }
        catch (TransformException te) {
            LOGR.fine(te.getMessage());
        }
        return destPos;
    }

    public static Coordinate[] transformRingToRightHandedCS(AbstractRing gmlRing) {
        MathTransform crsTransform;
        String srsName = gmlRing.getSrsName();
        if (null == srsName || srsName.isEmpty()) {
            return null;
        }
        CurveCoordinateListFactory curveCoordFactory = new CurveCoordinateListFactory();
        List<Coordinate> curveCoords = curveCoordFactory.createCoordinateList((AbstractGeometry)gmlRing);
        try {
            CoordinateReferenceSystem sourceCRS = CRS.decode((String)GeodesyUtils.getAbbreviatedCRSIdentifier(srsName));
            CoordinateReferenceSystem targetCRS = CRS.decode((String)GeodesyUtils.getAbbreviatedCRSIdentifier(srsName), (boolean)true);
            crsTransform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
        }
        catch (FactoryException fx) {
            throw new RuntimeException("Failed to create coordinate transformer.", fx);
        }
        for (Coordinate coord : curveCoords) {
            try {
                JTS.transform((Coordinate)coord, (Coordinate)coord, (MathTransform)crsTransform);
            }
            catch (TransformException tx) {
                throw new RuntimeException("Failed to transform coordinate: " + coord, tx);
            }
        }
        GeodesyUtils.removeConsecutiveDuplicates(curveCoords, 1);
        return curveCoords.toArray(new Coordinate[curveCoords.size()]);
    }

    public static String getAbbreviatedCRSIdentifier(String srsName) {
        String separator;
        StringBuilder crsId = new StringBuilder();
        int crsIndex = srsName.indexOf("crs");
        if (srsName.startsWith("http://www.opengis.net")) {
            separator = "/";
        } else if (srsName.startsWith("urn:ogc")) {
            separator = ":";
        } else {
            throw new IllegalArgumentException("Invalid CRS reference (see OGC 09-048r3): " + srsName);
        }
        String[] parts = srsName.substring(crsIndex + 4).split(separator);
        if (parts.length == 3) {
            crsId.append(parts[0]).append(':').append(parts[2]);
        }
        return crsId.toString();
    }

    public static String convertSRSNameToURN(String srsName) {
        if (!srsName.startsWith("http")) {
            return srsName;
        }
        StringBuilder urn = new StringBuilder("urn:ogc:def:crs:");
        String[] srsNameParts = srsName.split("/");
        int numParts = srsNameParts.length;
        urn.append(srsNameParts[numParts - 3]).append(':');
        String ver = srsNameParts[numParts - 2];
        if (!ver.isEmpty() && !ver.equals("0")) {
            urn.append(ver);
        }
        urn.append(':').append(srsNameParts[numParts - 1]);
        return urn.toString();
    }

    public static void removeConsecutiveDuplicates(List<Coordinate> coordList, int tolerancePPM) {
        if (coordList.size() < 2) {
            return;
        }
        double tolerance = (double)tolerancePPM * 1.0E-6;
        ListIterator<Coordinate> itr = coordList.listIterator();
        Coordinate prevCoord = itr.next();
        while (itr.hasNext()) {
            Coordinate coord = itr.next();
            double xDelta = Math.abs(coord.x / prevCoord.x - 1.0);
            double yDelta = Math.abs(coord.y / prevCoord.y - 1.0);
            if (xDelta <= tolerance && yDelta <= tolerance) {
                itr.remove();
                continue;
            }
            prevCoord = coord;
        }
    }
}

