/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.sql.table;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.util.Locale;
import org.geotoolkit.internal.sql.table.Column;
import org.geotoolkit.internal.sql.table.Table;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.IndexedResourceBundle;
import org.geotoolkit.util.converter.Classes;

public class CatalogException
extends SQLNonTransientException {
    private static final long serialVersionUID = 3838293108990270182L;
    private String table;
    private String column;
    private Comparable<?> key;
    private Locale locale;

    public CatalogException() {
    }

    public CatalogException(String string) {
        super(string);
    }

    public CatalogException(Exception exception) {
        super(exception);
    }

    public CatalogException(String string, Exception exception) {
        super(string, exception);
    }

    final boolean isMetadataInitialized() {
        return this.table != null || this.column != null || this.key != null;
    }

    final void setMetadata(Column column, Comparable<?> comparable) {
        this.table = column.table;
        this.column = column.name;
        this.key = comparable;
    }

    final void setMetadata(Table table, ResultSet resultSet, int n, Comparable<?> comparable) throws SQLException {
        Object object;
        boolean bl = true;
        boolean bl2 = true;
        if (resultSet != null && n != 0 && !resultSet.isClosed()) {
            object = resultSet.getMetaData();
            if (object != null) {
                this.table = object.getTableName(n);
                this.column = object.getColumnName(n);
                bl = this.table == null || (this.table = this.table.trim()).isEmpty();
                bl2 = this.column == null || (this.column = this.column.trim()).isEmpty();
            }
            resultSet.close();
        }
        if (table != null) {
            this.locale = table.getLocale();
            if ((bl || bl2) && (object = table.getColumn(n)) != null) {
                if (bl) {
                    this.table = ((Column)object).table;
                }
                if (bl2) {
                    this.column = ((Column)object).name;
                }
            }
        }
        this.key = comparable;
    }

    final void clearColumnName() {
        this.column = null;
    }

    public String getTableName() {
        return this.table;
    }

    public String getColumnName() {
        return this.column;
    }

    public Comparable<?> getPrimaryKey() {
        return this.key;
    }

    final IndexedResourceBundle errors() {
        return Errors.getResources((Locale)this.locale);
    }

    @Override
    public String getLocalizedMessage() {
        Object object;
        String string = super.getLocalizedMessage();
        if (string == null && (object = this.getCause()) != null && (string = ((Throwable)object).getLocalizedMessage()) == null) {
            string = Classes.getShortClassName((Object)object);
        }
        object = this.getTableName();
        String string2 = this.getColumnName();
        Comparable<?> comparable = this.getPrimaryKey();
        if (object != null) {
            Object[] objectArray;
            int n;
            if (string2 != null) {
                if (comparable != null) {
                    n = 33;
                    objectArray = new Comparable[]{object, string2, comparable};
                } else {
                    n = 35;
                    objectArray = new String[]{object, string2};
                }
            } else if (comparable != null) {
                n = 32;
                objectArray = new Comparable[]{object, comparable};
            } else {
                n = 34;
                objectArray = new String[]{object};
            }
            String string3 = this.errors().getString(n, (Object)objectArray);
            if (string != null) {
                string = string3 + ' ' + string;
            }
        }
        return string;
    }
}

