/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19136.general;

import java.util.List;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSTypeDefinition;
import org.opengis.cite.iso19136.ETSAssert;
import org.opengis.cite.iso19136.ErrorMessage;
import org.opengis.cite.iso19136.general.SchemaModelFixture;
import org.opengis.cite.iso19136.util.GMLObjectTypeFilter;
import org.opengis.cite.iso19136.util.XMLSchemaModelUtils;
import org.testng.annotations.Test;

public class ComplexPropertyTests
extends SchemaModelFixture {
    @Test(description="See ISO 19136: 7.2.6, A.1.1.9")
    public void validateMetadataProperties() {
        XSTypeDefinition metadataPropType = this.model.getTypeDefinition("AbstractMetadataPropertyType", "http://www.opengis.net/gml/3.2");
        List<XSElementDeclaration> metadataProps = XMLSchemaModelUtils.getGlobalElementsByType(this.model, metadataPropType);
        metadataProps.addAll(XMLSchemaModelUtils.getLocalElementsByType(this.model, metadataPropType, new GMLObjectTypeFilter()));
        for (XSElementDeclaration metaDataProp : metadataProps) {
            ETSAssert.assertValidPropertyType(this.model, metaDataProp, null);
            XSComplexTypeDefinition propTypeDef = (XSComplexTypeDefinition)metaDataProp.getTypeDefinition();
            if (propTypeDef.getContentType() == 0) {
                throw new AssertionError((Object)ErrorMessage.format("MetadataPropertyUnspecified", metaDataProp));
            }
        }
    }

    @Test(description="See ISO 19136: 7.2.5, A.1.1.14")
    public void validateMembersOfGmlObjectCollection() {
        XSTypeDefinition memberPropType = this.model.getTypeDefinition("AbstractMemberType", "http://www.opengis.net/gml/3.2");
        List<XSElementDeclaration> memberProps = XMLSchemaModelUtils.getGlobalElementsByType(this.model, memberPropType);
        memberProps.addAll(XMLSchemaModelUtils.getLocalElementsByType(this.model, memberPropType, null));
        XSElementDeclaration gmlObj = this.model.getElementDeclaration("AbstractGML", "http://www.opengis.net/gml/3.2");
        for (XSElementDeclaration memberProp : memberProps) {
            ETSAssert.assertValidPropertyType(this.model, memberProp, gmlObj);
        }
    }
}

