/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.util;

import com.occamlab.te.util.DomUtils;
import com.occamlab.te.util.Soap11MessageBuilder;
import com.occamlab.te.util.Soap12MessageBuilder;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class SoapUtils {
    public static final String SOAP_V_1_1 = "1.1";
    public static final String SOAP_V_1_2 = "1.2";

    public static Document getSOAPMessage(InputStream in) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setExpandEntityReferences(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document soapMessage = db.newDocument();
        TransformerFactory tf = TransformerFactory.newInstance();
        tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer t = tf.newTransformer();
        t.transform(new StreamSource(in), new DOMResult(soapMessage));
        return soapMessage;
    }

    public static Document getSoapBody(Document soapMessage) throws Exception {
        Element envelope = soapMessage.getDocumentElement();
        Element body = DomUtils.getChildElement(DomUtils.getElementByTagName(envelope, envelope.getPrefix() + ":Body"));
        Document content = DomUtils.createDocument(body);
        Element documentRoot = content.getDocumentElement();
        SoapUtils.addNSdeclarations(envelope, documentRoot);
        SoapUtils.addNSdeclarations(body, documentRoot);
        return content;
    }

    public static void addNSdeclarations(Element source, Element target) throws Exception {
        NamedNodeMap sourceAttributes = source.getAttributes();
        for (int i = 0; i <= sourceAttributes.getLength() - 1; ++i) {
            Attr attribute = (Attr)sourceAttributes.item(i);
            String attributeName = attribute.getName();
            if (!attributeName.startsWith("xmlns") || attributeName.startsWith("xmlns:soap-env")) continue;
            target.setAttribute(attributeName, attribute.getValue());
        }
    }

    public static byte[] getSoapMessageAsByte(String version, List headerBlocks, Element body, String encoding) throws Exception {
        Document message = SoapUtils.createSoapMessage(version, headerBlocks, body);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TransformerFactory tf = TransformerFactory.newInstance();
        tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer t = tf.newTransformer();
        t.setOutputProperty("encoding", encoding);
        t.transform(new DOMSource(message), new StreamResult(baos));
        return baos.toByteArray();
    }

    public static Document createSoapMessage(String version, List headerBlocks, Element body) throws Exception {
        Document message = null;
        int i = 0;
        NodeList children = body.getChildNodes();
        if (i < children.getLength()) {
            Document bodyDoc;
            if (children.item(i).getNodeType() != 1 && children.item(i).getNodeType() == 3 && (bodyDoc = DomUtils.convertToElementNode(body.getTextContent().trim())).getFirstChild().getNodeType() == 1) {
                body = (Element)bodyDoc.getFirstChild();
            }
            message = version.equals(SOAP_V_1_1) ? Soap11MessageBuilder.getSoapMessage(headerBlocks, body) : Soap12MessageBuilder.getSoapMessage(headerBlocks, body);
        }
        return message;
    }
}

