/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.temporal.reference;

import java.util.Date;
import org.geotoolkit.temporal.object.DefaultTemporalCoordinate;
import org.geotoolkit.temporal.reference.DefaultTemporalReferenceSystem;
import org.geotoolkit.util.Utilities;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.temporal.TemporalCoordinate;
import org.opengis.temporal.TemporalCoordinateSystem;
import org.opengis.util.InternationalString;

public class DefaultTemporalCoordinateSystem
extends DefaultTemporalReferenceSystem
implements TemporalCoordinateSystem {
    private Date origin;
    private InternationalString interval;

    public DefaultTemporalCoordinateSystem(ReferenceIdentifier name, Extent domainOfValidity, Date origin, InternationalString interval) {
        super(name, domainOfValidity);
        this.origin = origin;
        this.interval = interval;
    }

    public void setOrigin(Date origin) {
        this.origin = origin;
    }

    public void setInterval(InternationalString interval) {
        this.interval = interval;
    }

    @Override
    public Date getOrigin() {
        return this.origin;
    }

    @Override
    public InternationalString getInterval() {
        return this.interval;
    }

    @Override
    public Date transformCoord(TemporalCoordinate c_value) {
        DefaultTemporalCoordinate value = (DefaultTemporalCoordinate)c_value;
        Number f = 0;
        if (value.getFrame() != null && value.getFrame() instanceof TemporalCoordinateSystem) {
            if (value.getCoordinateValue() != null) {
                String interStr = ((Object)this.interval).toString();
                float n = value.getCoordinateValue().floatValue();
                if ("year".equals(interStr)) {
                    f = Float.valueOf(n * 3.1536E10f);
                } else if ("month".equals(interStr)) {
                    f = Float.valueOf(n * 2.628E9f);
                } else if ("week".equals(interStr)) {
                    f = Float.valueOf(n * 6.048E8f);
                } else if ("day".equals(interStr)) {
                    f = Float.valueOf(n * 8.64E7f);
                } else if ("hour".equals(interStr)) {
                    f = Float.valueOf(n * 3600000.0f);
                } else if ("minute".equals(interStr)) {
                    f = Float.valueOf(n * 60000.0f);
                } else if ("second".equals(interStr)) {
                    f = Float.valueOf(n * 1000.0f);
                } else if ("millisecond".equals(interStr)) {
                    f = Float.valueOf(n);
                } else {
                    throw new IllegalArgumentException("The name of a single unit of measure used as the base interval for the scale in this current TemporalCoordinateSystem is not supported !");
                }
                Date response = new Date(this.origin.getTime() + f.longValue());
                return response;
            }
            return null;
        }
        throw new IllegalArgumentException("The TemporalCoordinate argument must be a TemporalCoordinate ! ");
    }

    @Override
    public TemporalCoordinate transformDateTime(Date dateTime) {
        String intervalStr = ((Object)this.interval).toString();
        Number coordinateValue = Math.abs(dateTime.getTime() - this.origin.getTime());
        float val = ((Number)coordinateValue).floatValue();
        if ("year".equals(intervalStr)) {
            coordinateValue = Float.valueOf(val / 3.1536E10f);
        } else if ("month".equals(intervalStr)) {
            coordinateValue = Float.valueOf(val / 2.628E9f);
        } else if ("week".equals(intervalStr)) {
            coordinateValue = Float.valueOf(val / 6.048E8f);
        } else if ("day".equals(intervalStr)) {
            coordinateValue = Float.valueOf(val / 8.64E7f);
        } else if ("hour".equals(intervalStr)) {
            coordinateValue = Float.valueOf(val / 3600000.0f);
        } else if ("minute".equals(intervalStr)) {
            coordinateValue = Float.valueOf(val / 60000.0f);
        } else if ("second".equals(intervalStr)) {
            coordinateValue = Float.valueOf(val / 1000.0f);
        }
        return new DefaultTemporalCoordinate(this, null, coordinateValue);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DefaultTemporalCoordinateSystem && super.equals(object) && object instanceof DefaultTemporalCoordinateSystem) {
            DefaultTemporalCoordinateSystem that = (DefaultTemporalCoordinateSystem)object;
            return Utilities.equals(this.interval, that.interval) && Utilities.equals(this.origin, that.origin);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + (this.interval != null ? this.interval.hashCode() : 0);
        hash = 37 * hash + (this.origin != null ? this.origin.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder("TemporalCoordinateSystem:").append('\n');
        if (this.interval != null) {
            s2.append("interval:").append(this.interval).append('\n');
        }
        if (this.origin != null) {
            s2.append("origin:").append(this.origin).append('\n');
        }
        return s2.toString();
    }
}

