/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wfs11;

import java.io.ByteArrayInputStream;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.xerces.dom.DOMInputImpl;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSImplementation;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.opengis.cite.iso19136.util.NamespaceBindings;
import org.opengis.cite.wfs11.domain.FeatureData;
import org.opengis.cite.wfs11.util.NamespaceBindingUtils;
import org.opengis.cite.wfs11.util.XmlUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;

public class GetFeatureTestConditions {
    public static boolean checkFeaturesMatchingFilter(Node featureCollection, Node featureData) throws Exception {
        try {
            FeatureData parsedFeatureData = GetFeatureTestConditions.parseFeatureData(XmlUtils.reloadNode(featureData));
            NodeList featureMembers = GetFeatureTestConditions.findFeatureMembers(XmlUtils.reloadNode(featureCollection), parsedFeatureData);
            for (int i = 0; i < featureMembers.getLength(); ++i) {
                Node featureMember = featureMembers.item(i);
                if (GetFeatureTestConditions.hasProperty(featureMember, parsedFeatureData)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static boolean checkFeatureTypesDescribedInSchema(Node capabilitiesResponse, Node describeFeatureTypeResponse) throws Exception {
        try {
            XSModel model = GetFeatureTestConditions.parseSchema(XmlUtils.reloadNode(describeFeatureTypeResponse));
            NodeList featureTypeNames = GetFeatureTestConditions.parseFeatureTypeNames(XmlUtils.reloadNode(capabilitiesResponse));
            for (int i = 0; i < featureTypeNames.getLength(); ++i) {
                Node featureTypeNameNode = featureTypeNames.item(i);
                QName featureTypeName = XmlUtils.buildQName(featureTypeNameNode);
                XSElementDeclaration elementDeclaration = model.getElementDeclaration(featureTypeName.getLocalPart(), featureTypeName.getNamespaceURI());
                if (elementDeclaration != null) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XSModel parseSchema(Node node) throws Exception {
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        XSImplementation impl = (XSImplementation)((Object)registry.getDOMImplementation("XS-Loader"));
        XSLoader schemaLoader = impl.createXSLoader(null);
        DOMInputImpl lsInput = new DOMInputImpl();
        try (ByteArrayInputStream bis = new ByteArrayInputStream(XmlUtils.asString(node).getBytes());){
            lsInput.setByteStream(bis);
            XSModel xSModel = schemaLoader.load(lsInput);
            return xSModel;
        }
    }

    private static NodeList parseFeatureTypeNames(Node capabilities) throws XPathExpressionException {
        NamespaceBindings nsBindings = new NamespaceBindingUtils.NamespaceBindingBuilder().add("wfs", "http://www.opengis.net/wfs").build();
        String xPath = "//wfs:FeatureTypeList/wfs:FeatureType/wfs:Name";
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(nsBindings);
        return (NodeList)xpath.evaluate(xPath, capabilities, XPathConstants.NODESET);
    }

    private static FeatureData parseFeatureData(Node featureData) throws XPathExpressionException {
        String featureTypeName = GetFeatureTestConditions.evaluate("//FeatureData/FeatureType/localName", featureData);
        String featureTypeNamespace = GetFeatureTestConditions.evaluate("//FeatureData/FeatureType/namespace", featureData);
        String propertyName = GetFeatureTestConditions.evaluate("//FeatureData/Property/localName", featureData);
        String propertyNamespace = GetFeatureTestConditions.evaluate("//FeatureData/Property/namespace", featureData);
        String value = GetFeatureTestConditions.evaluate("//FeatureData/value", featureData);
        return new FeatureData(new QName(featureTypeNamespace, featureTypeName), new QName(propertyNamespace, propertyName), value);
    }

    private static NodeList findFeatureMembers(Node featureCollection, FeatureData featureData) throws XPathExpressionException {
        String typeNamespace = featureData.getFeatureType().getNamespaceURI();
        String typeName = featureData.getFeatureType().getLocalPart();
        NamespaceBindings nsBindings = new NamespaceBindingUtils.NamespaceBindingBuilder().add("n1", typeNamespace).add("wfs", "http://www.opengis.net/wfs").add("gml", "http://www.opengis.net/gml").build();
        StringBuilder xPathBuilder = new StringBuilder();
        xPathBuilder.append("//wfs:FeatureCollection/gml:featureMember/");
        xPathBuilder.append(nsBindings.getPrefix(typeNamespace)).append(":").append(typeName);
        xPathBuilder.append(" | ");
        xPathBuilder.append("//wfs:FeatureCollection/gml:featureMembers/");
        xPathBuilder.append(nsBindings.getPrefix(typeNamespace)).append(":").append(typeName);
        String xPath = xPathBuilder.toString();
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(nsBindings);
        return (NodeList)xpath.evaluate(xPath, featureCollection, XPathConstants.NODESET);
    }

    private static boolean hasProperty(Node featureMember, FeatureData featureData) throws XPathExpressionException {
        String propertyNamespace = featureData.getPropName().getNamespaceURI();
        String propertyName = featureData.getPropName().getLocalPart();
        String value = featureData.getData();
        NodeList featureProperties = GetFeatureTestConditions.parseProperties(featureMember, propertyNamespace, propertyName);
        for (int i = 0; i < featureProperties.getLength(); ++i) {
            Node property = featureProperties.item(i);
            String textContent = property.getTextContent();
            if (!value.equals(textContent)) continue;
            return true;
        }
        return false;
    }

    private static NodeList parseProperties(Node featureMember, String propertyNamespace, String propertyName) throws XPathExpressionException {
        NamespaceBindings nsBindings = new NamespaceBindingUtils.NamespaceBindingBuilder().add("n1", propertyNamespace).add("wfs", "http://www.opengis.net/wfs").add("gml", "http://www.opengis.net/gml").build();
        StringBuilder xPathBuilder = new StringBuilder();
        xPathBuilder.append("//");
        xPathBuilder.append(nsBindings.getPrefix(propertyNamespace));
        xPathBuilder.append(":");
        xPathBuilder.append(propertyName);
        String xPath = xPathBuilder.toString();
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(nsBindings);
        return (NodeList)xpath.evaluate(xPath, featureMember, XPathConstants.NODESET);
    }

    private static String evaluate(String xPath, Node featureData) throws XPathExpressionException {
        return (String)XPathFactory.newInstance().newXPath().evaluate(xPath, featureData, XPathConstants.STRING);
    }
}

