/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wfs11;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.xerces.dom.DOMInputImpl;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSImplementation;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSTypeDefinition;
import org.opengis.cite.iso19136.util.NamespaceBindings;
import org.opengis.cite.wfs11.WFSClient;
import org.opengis.cite.wfs11.domain.FeatureData;
import org.opengis.cite.wfs11.util.NamespaceBindingUtils;
import org.opengis.cite.wfs11.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.xml.sax.SAXException;

public class GetFeatureTestExtension {
    public static Node findFeatureTypeAndPropertyName(Node wfsCapabilities) throws Exception {
        try {
            Node wfsCapabilitiesReloaded = XmlUtils.reloadNode(wfsCapabilities);
            WFSClient wfsClient = new WFSClient(wfsCapabilitiesReloaded);
            List<QName> featureTypeNames = GetFeatureTestExtension.parseFeatureTypeNames(wfsCapabilitiesReloaded);
            XSModel model = GetFeatureTestExtension.loadFeatureTypeModel(wfsClient);
            FeatureData featureData = GetFeatureTestExtension.acquireFeatureData(wfsClient, featureTypeNames, model);
            if (featureData != null) {
                return GetFeatureTestExtension.asXml(featureData).getDocumentElement();
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private static XSModel loadFeatureTypeModel(WFSClient wfsClient) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException, XPathExpressionException {
        InputStream featureType = wfsClient.getFeatureType();
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        XSImplementation impl = (XSImplementation)((Object)registry.getDOMImplementation("XS-Loader"));
        XSLoader schemaLoader = impl.createXSLoader(null);
        DOMInputImpl lsInput = new DOMInputImpl();
        lsInput.setByteStream(featureType);
        return schemaLoader.load(lsInput);
    }

    private static List<QName> parseFeatureTypeNames(Node wfsCapabilities) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        ArrayList<QName> featureInfo = new ArrayList<QName>();
        XPath xpath = XPathFactory.newInstance().newXPath();
        NamespaceBindings nsBindings = new NamespaceBindings();
        nsBindings.addNamespaceBinding("http://www.opengis.net/wfs", "wfs");
        xpath.setNamespaceContext(nsBindings);
        NodeList nodes = (NodeList)xpath.evaluate("//wfs:FeatureTypeList/wfs:FeatureType/wfs:Name", wfsCapabilities, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            featureInfo.add(XmlUtils.buildQName(node));
        }
        return featureInfo;
    }

    private static FeatureData acquireFeatureData(WFSClient wfsClient, List<QName> featureTypes, XSModel model) throws Exception {
        for (QName featureType : featureTypes) {
            Document rspEntity = wfsClient.getFeatureByType(featureType);
            String typeName = featureType.getLocalPart();
            String typeNamespace = featureType.getNamespaceURI();
            NodeList features = rspEntity.getElementsByTagNameNS(typeNamespace, typeName);
            boolean hasFeatures = features.getLength() > 0;
            if (!hasFeatures) continue;
            List<XSElementDeclaration> featureProperties = GetFeatureTestExtension.findSimpleProperties(model, featureType);
            for (XSElementDeclaration featureProperty : featureProperties) {
                FeatureData featureDataForProperty = GetFeatureTestExtension.aquireFeatureData(featureType, rspEntity, typeName, typeNamespace, featureProperty);
                if (featureDataForProperty == null) continue;
                return featureDataForProperty;
            }
        }
        return null;
    }

    private static FeatureData aquireFeatureData(QName featureType, Document rspEntity, String typeName, String typeNamespace, XSElementDeclaration featureProperty) throws XPathExpressionException {
        Object property;
        String propName = featureProperty.getName();
        String propNamespace = featureProperty.getNamespace();
        if (!"http://www.opengis.net/gml".equals(propNamespace) && (property = GetFeatureTestExtension.extractProperty(rspEntity, typeName, typeNamespace, propName, propNamespace)) instanceof NodeList) {
            NodeList nodes = (NodeList)property;
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String textContent = node.getTextContent();
                if (textContent == null || textContent.isEmpty()) continue;
                QName propertyQName = new QName(propNamespace, propName);
                return new FeatureData(featureType, propertyQName, textContent);
            }
        }
        return null;
    }

    private static List<XSElementDeclaration> findSimpleProperties(XSModel model, QName featureType) {
        XSTypeDefinition xsdDoubleType = model.getTypeDefinition("double", "http://www.w3.org/2001/XMLSchema");
        XSTypeDefinition xsdDecimalType = model.getTypeDefinition("decimal", "http://www.w3.org/2001/XMLSchema");
        XSTypeDefinition xsdIntegerType = model.getTypeDefinition("integer", "http://www.w3.org/2001/XMLSchema");
        XSTypeDefinition xsdStringType = model.getTypeDefinition("string", "http://www.w3.org/2001/XMLSchema");
        return XmlUtils.getFeaturePropertiesByType(model, featureType, xsdDecimalType, xsdDoubleType, xsdIntegerType, xsdStringType);
    }

    private static Object extractProperty(Document rspEntity, String typeName, String typeNamespace, String propName, String propNamespace) throws XPathExpressionException {
        NamespaceBindings nsBindings = new NamespaceBindingUtils.NamespaceBindingBuilder().add("n1", typeNamespace).add("n2", propNamespace).add("wfs", "http://www.opengis.net/wfs").add("gml", "http://www.opengis.net/gml").build();
        StringBuilder xPathBuilder = new StringBuilder();
        xPathBuilder.append("//wfs:FeatureCollection/gml:featureMember/");
        xPathBuilder.append(nsBindings.getPrefix(typeNamespace)).append(":").append(typeName).append("/");
        xPathBuilder.append(nsBindings.getPrefix(propNamespace)).append(":").append(propName);
        xPathBuilder.append(" | ");
        xPathBuilder.append("//wfs:FeatureCollection/gml:featureMembers/");
        xPathBuilder.append(nsBindings.getPrefix(typeNamespace)).append(":").append(typeName).append("/");
        xPathBuilder.append(nsBindings.getPrefix(propNamespace)).append(":").append(propName);
        String xPath = xPathBuilder.toString();
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(nsBindings);
        return xpath.evaluate(xPath, rspEntity, XPathConstants.NODESET);
    }

    private static Document asXml(FeatureData featureData) throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element rootElement = doc.createElement("FeatureData");
        doc.appendChild(rootElement);
        Element featureTypeElement = doc.createElement("FeatureType");
        rootElement.appendChild(featureTypeElement);
        Element featureTypeLocalNameElement = doc.createElement("localName");
        featureTypeLocalNameElement.setTextContent(featureData.getFeatureType().getLocalPart());
        featureTypeElement.appendChild(featureTypeLocalNameElement);
        Element featureTypeNamespaceElement = doc.createElement("namespace");
        featureTypeNamespaceElement.setTextContent(featureData.getFeatureType().getNamespaceURI());
        featureTypeElement.appendChild(featureTypeNamespaceElement);
        Element propertyElement = doc.createElement("Property");
        rootElement.appendChild(propertyElement);
        Element propertyLocalNameElement = doc.createElement("localName");
        propertyLocalNameElement.setTextContent(featureData.getPropName().getLocalPart());
        propertyElement.appendChild(propertyLocalNameElement);
        Element propertyNamespaceElement = doc.createElement("namespace");
        propertyNamespaceElement.setTextContent(featureData.getPropName().getNamespaceURI());
        propertyElement.appendChild(propertyNamespaceElement);
        Element valueElement = doc.createElement("value");
        valueElement.setTextContent(featureData.getData());
        rootElement.appendChild(valueElement);
        return doc;
    }
}

