/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.geomatics.gml;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.geotoolkit.gml.xml.AbstractCurveSegment;
import org.geotoolkit.gml.xml.DirectPosition;
import org.geotoolkit.gml.xml.LineStringSegment;
import org.geotoolkit.gml.xml.v321.ArcStringType;
import org.geotoolkit.gml.xml.v321.DirectPositionType;
import org.geotoolkit.gml.xml.v321.GeodesicStringType;
import org.opengis.cite.geomatics.gml.GmlUtils;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public enum CurveSegmentType {
    LINE_STRING{

        @Override
        public List<Coordinate> getCoordinateList(AbstractCurveSegment segment, CoordinateReferenceSystem crs) {
            if (null == crs) {
                throw new IllegalArgumentException("No CRS supplied for curve segment.");
            }
            LineStringSegment lineSegment = (LineStringSegment)LineStringSegment.class.cast(segment);
            ArrayList<Double> posList = new ArrayList<Double>();
            if (null == lineSegment.getPosList()) {
                for (DirectPosition pos : lineSegment.getPos()) {
                    posList.addAll(pos.getValue());
                }
            } else {
                posList.addAll(lineSegment.getPosList().getValue());
            }
            ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
            GmlUtils.extractCoordinatesFromPosList(posList, crs.getCoordinateSystem().getDimension(), coords);
            return coords;
        }
    }
    ,
    GEODESIC_STRING{

        @Override
        public List<Coordinate> getCoordinateList(AbstractCurveSegment segment, CoordinateReferenceSystem crs) {
            if (null == crs) {
                throw new IllegalArgumentException("No CRS supplied for curve segment.");
            }
            GeodesicStringType geodesic = (GeodesicStringType)GeodesicStringType.class.cast(segment);
            ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
            GmlUtils.extractCoordinatesFromPosList(geodesic.getPosList().getValue(), crs.getCoordinateSystem().getDimension(), coords);
            return coords;
        }
    }
    ,
    ARC_BY_CENTER{

        @Override
        public List<Coordinate> getCoordinateList(AbstractCurveSegment segment, CoordinateReferenceSystem crs) {
            if (null == crs) {
                throw new IllegalArgumentException("No CRS supplied for curve segment.");
            }
            ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
            GmlUtils.inferPointsOnArc(segment, crs, coords);
            return coords;
        }
    }
    ,
    ARC_STRING{

        @Override
        public List<Coordinate> getCoordinateList(AbstractCurveSegment segment, CoordinateReferenceSystem crs) {
            if (null == crs) {
                throw new IllegalArgumentException("No CRS supplied for curve segment.");
            }
            ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
            ArcStringType arcType = (ArcStringType)ArcStringType.class.cast(segment);
            if (null != arcType.getPosList()) {
                GmlUtils.extractCoordinatesFromPosList(arcType.getPosList().getValue(), crs.getCoordinateSystem().getDimension(), coords);
            } else {
                List points = arcType.getPosOrPointPropertyOrPointRep();
                for (JAXBElement elem : points) {
                    DirectPositionType pos = (DirectPositionType)elem.getValue();
                    coords.add(new Coordinate(pos.getOrdinate(0), pos.getOrdinate(1)));
                }
            }
            return coords;
        }
    };


    public abstract List<Coordinate> getCoordinateList(AbstractCurveSegment var1, CoordinateReferenceSystem var2);
}

