/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.type.SchemaType;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class AugmentedSource
implements Source {
    private Source source;
    private int schemaValidation = 0;
    private int dtdValidation = 0;
    private StructuredQName topLevelElement;
    private SchemaType topLevelType;
    private XMLReader parser = null;
    private Boolean wrapDocument = null;
    private int treeModel = -1;
    private int stripSpace;
    private Boolean lineNumbering = null;
    private Boolean xIncludeAware = null;
    private boolean pleaseClose = false;
    private EntityResolver entityResolver = null;
    private ErrorListener errorListener = null;
    private List filters = null;

    private AugmentedSource(Source source) {
        if (source instanceof AugmentedSource) {
            throw new IllegalArgumentException("Contained source must not be an AugmentedSource");
        }
        this.source = source;
    }

    public static AugmentedSource makeAugmentedSource(Source source) {
        if (source instanceof AugmentedSource) {
            return (AugmentedSource)source;
        }
        return new AugmentedSource(source);
    }

    public void addFilter(ProxyReceiver filter) {
        if (this.filters == null) {
            this.filters = new ArrayList(5);
        }
        this.filters.add(filter);
    }

    public List getFilters() {
        return this.filters;
    }

    public Source getContainedSource() {
        return this.source;
    }

    public void setStripSpace(int stripAction) {
        this.stripSpace = stripAction;
    }

    public int getStripSpace() {
        return this.stripSpace;
    }

    public void setTreeModel(int model) {
        if (model != 1 && model != 0) {
            throw new IllegalArgumentException("model must be Builder.TINY_TREE or Builder.LINKED_TREE");
        }
        this.treeModel = model;
    }

    public int getTreeModel() {
        return this.treeModel;
    }

    public void setSchemaValidationMode(int option) {
        this.schemaValidation = option;
    }

    public int getSchemaValidation() {
        return this.schemaValidation;
    }

    public void setTopLevelElement(StructuredQName elementName) {
        this.topLevelElement = elementName;
    }

    public StructuredQName getTopLevelElement() {
        return this.topLevelElement;
    }

    public void setTopLevelType(SchemaType type) {
        this.topLevelType = type;
    }

    public SchemaType getTopLevelType() {
        return this.topLevelType;
    }

    public void setDTDValidationMode(int option) {
        this.dtdValidation = option;
    }

    public int getDTDValidation() {
        return this.dtdValidation;
    }

    public void setLineNumbering(boolean lineNumbering) {
        this.lineNumbering = lineNumbering;
    }

    public boolean isLineNumbering() {
        return this.lineNumbering != null && this.lineNumbering != false;
    }

    public boolean isLineNumberingSet() {
        return this.lineNumbering != null;
    }

    public void setXMLReader(XMLReader parser) {
        this.parser = parser;
        if (this.source instanceof SAXSource) {
            ((SAXSource)this.source).setXMLReader(parser);
        }
    }

    public XMLReader getXMLReader() {
        if (this.parser != null) {
            return this.parser;
        }
        if (this.source instanceof SAXSource) {
            return ((SAXSource)this.source).getXMLReader();
        }
        return null;
    }

    public void setWrapDocument(Boolean wrap) {
        this.wrapDocument = wrap;
    }

    public Boolean getWrapDocument() {
        return this.wrapDocument;
    }

    public void setSystemId(String id) {
        this.source.setSystemId(id);
    }

    public String getSystemId() {
        return this.source.getSystemId();
    }

    public void setXIncludeAware(boolean state) {
        this.xIncludeAware = state;
    }

    public boolean isXIncludeAwareSet() {
        return this.xIncludeAware != null;
    }

    public boolean isXIncludeAware() {
        return this.xIncludeAware != null && this.xIncludeAware != false;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setErrorListener(ErrorListener listener) {
        this.errorListener = listener;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void setPleaseCloseAfterUse(boolean close) {
        this.pleaseClose = close;
    }

    public boolean isPleaseCloseAfterUse() {
        return this.pleaseClose;
    }

    public void close() {
        try {
            InputSource is;
            if (this.source instanceof StreamSource) {
                StreamSource ss = (StreamSource)this.source;
                if (ss.getInputStream() != null) {
                    ss.getInputStream().close();
                }
                if (ss.getReader() != null) {
                    ss.getReader().close();
                }
            } else if (this.source instanceof SAXSource && (is = ((SAXSource)this.source).getInputSource()) != null) {
                if (is.getByteStream() != null) {
                    is.getByteStream().close();
                }
                if (is.getCharacterStream() != null) {
                    is.getCharacterStream().close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

