/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wfs11.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTypeDefinition;
import org.opengis.cite.iso19136.util.XMLSchemaModelUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XmlUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node asNode(String xmlString) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        try (ByteArrayInputStream is = new ByteArrayInputStream(xmlString.getBytes());){
            Document wfsCapabilities = builder.parse(is);
            Element element = wfsCapabilities.getDocumentElement();
            return element;
        }
    }

    public static String asString(Node node) throws Exception {
        StringWriter writer = new StringWriter();
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.transform(new DOMSource(node), new StreamResult(writer));
        return writer.toString();
    }

    public static QName buildQName(Node node) {
        String nsName;
        String localPart;
        String name = node.getTextContent();
        int indexOfColon = name.indexOf(58);
        if (indexOfColon > 0) {
            localPart = name.substring(indexOfColon + 1);
            nsName = node.lookupNamespaceURI(name.substring(0, indexOfColon));
        } else {
            localPart = name;
            nsName = node.lookupNamespaceURI(null);
        }
        return new QName(nsName, localPart);
    }

    public static Node reloadNode(Node wfsCapabilities) throws Exception, SAXException, IOException, ParserConfigurationException {
        String capabilitiesAsString = XmlUtils.asString(wfsCapabilities);
        return XmlUtils.asNode(capabilitiesAsString);
    }

    public static List<XSElementDeclaration> getFeaturePropertiesByType(XSModel model, QName featureTypeName, XSTypeDefinition ... typeDefs) {
        XSElementDeclaration elemDecl = model.getElementDeclaration(featureTypeName.getLocalPart(), featureTypeName.getNamespaceURI());
        XSComplexTypeDefinition featureTypeDef = (XSComplexTypeDefinition)elemDecl.getTypeDefinition();
        List featureProps = XMLSchemaModelUtils.getAllElementsInParticle((XSParticle)featureTypeDef.getParticle());
        ArrayList<XSElementDeclaration> props = new ArrayList<XSElementDeclaration>();
        short extendOrRestrict = 3;
        for (XSElementDeclaration featureProp : featureProps) {
            XSTypeDefinition propType = featureProp.getTypeDefinition();
            block5: for (XSTypeDefinition typeDef : typeDefs) {
                switch (propType.getTypeCategory()) {
                    case 16: {
                        if (typeDef.getTypeCategory() != 16 || !propType.derivedFromType(typeDef, extendOrRestrict)) continue block5;
                        props.add(featureProp);
                        continue block5;
                    }
                    case 15: {
                        if (typeDef.getTypeCategory() == 15) {
                            XSComplexTypeDefinition complexPropType = (XSComplexTypeDefinition)propType;
                            List propValues = XMLSchemaModelUtils.getAllElementsInParticle((XSParticle)complexPropType.getParticle());
                            for (XSElementDeclaration propValue : propValues) {
                                if (!propValue.getTypeDefinition().derivedFromType(typeDef, extendOrRestrict)) continue;
                                props.add(featureProp);
                            }
                            continue block5;
                        }
                        if (!propType.derivedFromType(typeDef, extendOrRestrict)) continue block5;
                        props.add(featureProp);
                    }
                }
            }
        }
        return props;
    }
}

