/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.spi.jaxrs.resources;

import com.occamlab.te.spi.jaxrs.TestSuiteController;
import com.occamlab.te.spi.jaxrs.TestSuiteRegistry;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.json.simple.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

@Path(value="suites")
public class TestSuiteSetResource {
    @Context
    private UriInfo reqUriInfo;
    private static final String HTML_NS = "http://www.w3.org/1999/xhtml";
    private DocumentBuilder docBuilder;

    public TestSuiteSetResource() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            this.docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(TestSuiteSetResource.class.getName()).log(Level.WARNING, null, ex);
        }
    }

    @GET
    @Produces(value={"application/xhtml+xml; charset='utf-8'"})
    public Source listTestSuites() {
        Document xhtmlDoc = this.readTemplate();
        if (null == xhtmlDoc) {
            throw new WebApplicationException(Response.serverError().entity("Failed to parse test-suites.html").type("text/plain").build());
        }
        Element listElem = (Element)xhtmlDoc.getElementsByTagNameNS(HTML_NS, "ul").item(0);
        TestSuiteRegistry registry = TestSuiteRegistry.getInstance();
        Set<TestSuiteController> etsControllers = registry.getControllers();
        StringBuilder etsURI = new StringBuilder();
        for (TestSuiteController etsController : etsControllers) {
            Element li = xhtmlDoc.createElementNS(HTML_NS, "li");
            listElem.appendChild(li);
            Element link = xhtmlDoc.createElementNS(HTML_NS, "a");
            li.appendChild(link);
            Text title = xhtmlDoc.createTextNode(etsController.getTitle());
            link.appendChild(title);
            link.setAttribute("type", "text/html");
            if (!this.reqUriInfo.getPath().endsWith("/")) {
                etsURI.append(this.reqUriInfo.getPath()).append("/");
            }
            etsURI.append(etsController.getCode()).append("/");
            link.setAttribute("href", etsURI.toString());
            link.setAttribute("id", etsController.getCode());
            etsURI.setLength(0);
        }
        return new DOMSource(xhtmlDoc);
    }

    @GET
    @Produces(value={"application/xml; charset='utf-8'"})
    public Source listTestSuitesAsXML() {
        Document xmlDoc = this.docBuilder.newDocument();
        Element testSuites = xmlDoc.createElement("testSuites");
        xmlDoc.appendChild(testSuites);
        TestSuiteRegistry registry = TestSuiteRegistry.getInstance();
        Set<TestSuiteController> etsControllers = registry.getControllers();
        for (TestSuiteController etsController : etsControllers) {
            Element testSuite = xmlDoc.createElement("testSuite");
            testSuites.appendChild(testSuite);
            Element testSuiteTitle = xmlDoc.createElement("title");
            testSuiteTitle.setTextContent(etsController.getTitle());
            testSuite.appendChild(testSuiteTitle);
            Element testSuiteVersion = xmlDoc.createElement("version");
            testSuiteVersion.setTextContent(etsController.getVersion());
            testSuite.appendChild(testSuiteVersion);
            Element testSuiteRestUri = xmlDoc.createElement("endpoint");
            UriBuilder etsURI = this.reqUriInfo.getRequestUriBuilder();
            etsURI.path(etsController.getCode());
            testSuiteRestUri.setTextContent(etsURI.build(new Object[0]).toString());
            testSuite.appendChild(testSuiteRestUri);
            Element testSuiteEtsCode = xmlDoc.createElement("etscode");
            testSuiteEtsCode.setTextContent(etsController.getCode());
            testSuite.appendChild(testSuiteEtsCode);
        }
        return new DOMSource(xmlDoc);
    }

    @GET
    @Produces(value={"application/json"})
    public Response listTestSuitesAsJSON() {
        ArrayList<JSONObject> testSuiteList = new ArrayList<JSONObject>();
        TestSuiteRegistry registry = TestSuiteRegistry.getInstance();
        Set<TestSuiteController> etsControllers = registry.getControllers();
        for (TestSuiteController etsController : etsControllers) {
            StringBuilder etsURI = new StringBuilder();
            etsURI.append(this.reqUriInfo.getBaseUri());
            etsURI.append(this.reqUriInfo.getPath());
            etsURI.append(etsController.getCode()).append("/");
            HashMap<String, String> testSuiteInfoMap = new HashMap<String, String>();
            testSuiteInfoMap.put("title", etsController.getTitle());
            testSuiteInfoMap.put("version", etsController.getVersion());
            testSuiteInfoMap.put("etsCode", etsController.getCode());
            testSuiteInfoMap.put("endpoint", etsURI.toString());
            JSONObject testSuiteInfo = new JSONObject(testSuiteInfoMap);
            testSuiteList.add(testSuiteInfo);
        }
        HashMap<String, ArrayList<JSONObject>> testSuitesMap = new HashMap<String, ArrayList<JSONObject>>();
        testSuitesMap.put("testSuites", testSuiteList);
        JSONObject testSuites = new JSONObject(testSuitesMap);
        return Response.status(200).entity(testSuites.toString()).build();
    }

    Document readTemplate() {
        InputStream inStream = this.getClass().getResourceAsStream("test-suites.html");
        Document doc = null;
        try {
            doc = this.docBuilder.parse(inStream);
            inStream.close();
        }
        catch (Exception ex) {
            Logger.getLogger(TestSuiteSetResource.class.getName()).log(Level.WARNING, "Failed to parse test-suites.html", ex);
        }
        return doc;
    }
}

