/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.lang;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Locale;
import java.util.Properties;
import java.util.ServiceLoader;
import org.geotoolkit.factory.FactoryFinder;
import org.geotoolkit.internal.SetupService;
import org.geotoolkit.internal.io.Installation;
import org.geotoolkit.lang.Static;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.IndexedResourceBundle;
import org.geotoolkit.util.logging.Logging;

public final class Setup
extends Static {
    private static int state;

    private Setup() {
    }

    private static String get(Properties properties, String string, String string2) {
        return properties != null ? properties.getProperty(string, string2) : string2;
    }

    public static synchronized void initialize(Properties properties) throws IllegalStateException {
        boolean bl;
        if (state == 1) {
            return;
        }
        boolean bl2 = bl = state == 2;
        if (bl && !Boolean.parseBoolean(Setup.get(properties, "force", "false"))) {
            throw new IllegalStateException();
        }
        state = 1;
        if ("server".equalsIgnoreCase(Setup.get(properties, "platform", "desktop"))) {
            Installation.allowSystemPreferences = false;
            IndexedResourceBundle.immediateLocalization = true;
        } else {
            Logging.ALL.forceMonolineConsoleOutput(null);
        }
        if (bl) {
            FactoryFinder.scanForPlugins();
        }
        for (SetupService setupService : ServiceLoader.load(SetupService.class)) {
            setupService.initialize(properties, bl);
        }
    }

    public static synchronized void shutdown() {
        if (state != 2) {
            state = 2;
            for (SetupService setupService : ServiceLoader.load(SetupService.class)) {
                setupService.shutdown();
            }
        }
    }

    public static void showControlPanel() throws UnsupportedOperationException {
        try {
            Class.forName("org.geotoolkit.internal.setup.ControlPanel").getMethod("show", Locale.class).invoke(null, new Object[]{null});
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnsupportedOperationException(Errors.format(118, "geotk-setup"), classNotFoundException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new UndeclaredThrowableException(throwable);
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }
}

