/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.measure;

import java.io.Serializable;
import java.text.Format;
import java.text.ParseException;
import java.util.Locale;
import net.jcip.annotations.Immutable;
import org.geotoolkit.measure.AngleFormat;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.converter.ConverterRegistry;
import org.geotoolkit.util.converter.SimpleConverter;

@Immutable
public class Angle
implements Comparable<Angle>,
Serializable {
    private static final long serialVersionUID = 1158747349433104534L;
    private static Format format;
    private final double theta;

    public Angle(double d) {
        this.theta = d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Angle(String string) throws NumberFormatException {
        Angle angle;
        Format format = Angle.getAngleFormat();
        try {
            Class<Angle> clazz = Angle.class;
            synchronized (Angle.class) {
                angle = (Angle)format.parseObject(string);
                // ** MonitorExit[var4_3] (shouldn't be in output)
            }
        }
        catch (ParseException parseException) {
            NumberFormatException numberFormatException = new NumberFormatException(parseException.getLocalizedMessage());
            numberFormatException.initCause(parseException);
            throw numberFormatException;
        }
        {
            if (!this.getClass().isAssignableFrom(angle.getClass())) {
                throw new NumberFormatException(string);
            }
            this.theta = angle.theta;
            return;
        }
    }

    public double degrees() {
        return this.theta;
    }

    public double radians() {
        return Math.toRadians(this.theta);
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.theta);
        return (int)l ^ (int)(l >>> 32);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            return Utilities.equals(this.theta, ((Angle)object).theta);
        }
        return false;
    }

    @Override
    public int compareTo(Angle angle) {
        return Double.compare(this.theta, angle.theta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Class<Angle> clazz = Angle.class;
        synchronized (Angle.class) {
            Format format = Angle.getAngleFormat();
            stringBuffer = format.format(this, stringBuffer, null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return stringBuffer.toString();
        }
    }

    private static Format getAngleFormat() {
        assert (Thread.holdsLock(Angle.class));
        if (format == null) {
            format = AngleFormat.getInstance(Locale.CANADA);
        }
        return format;
    }

    static {
        ConverterRegistry converterRegistry = ConverterRegistry.system();
        converterRegistry.register(new SimpleConverter<Angle, Double>(){

            @Override
            public Class<Angle> getSourceClass() {
                return Angle.class;
            }

            @Override
            public Class<Double> getTargetClass() {
                return Double.class;
            }

            @Override
            public Double convert(Angle angle) {
                return angle.theta;
            }
        });
        converterRegistry.register(new SimpleConverter<Double, Angle>(){

            @Override
            public Class<Double> getSourceClass() {
                return Double.class;
            }

            @Override
            public Class<Angle> getTargetClass() {
                return Angle.class;
            }

            @Override
            public Angle convert(Double d) {
                return new Angle(d);
            }
        });
    }
}

