/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.transform;

import org.geotoolkit.parameter.Parameters;
import org.geotoolkit.referencing.operation.provider.NTv2;
import org.geotoolkit.referencing.operation.transform.GridTransform2D;
import org.geotoolkit.referencing.operation.transform.GridType;
import org.geotoolkit.referencing.operation.transform.NTv2Loader;
import org.geotoolkit.resources.Errors;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.FactoryException;

public class NTv2Transform
extends GridTransform2D {
    private static final long serialVersionUID = -1351957989631930381L;
    public static final String RGF93 = "ntf_r93.gsb";
    private final String gridFile;

    public NTv2Transform(String string) throws FactoryException {
        this(NTv2Loader.loadIfAbsent(string, false));
    }

    private NTv2Transform(NTv2Loader nTv2Loader) throws FactoryException {
        super(GridType.NTv2, nTv2Loader.getDataBuffer(), nTv2Loader.getSize(), nTv2Loader.getArea());
        String string = nTv2Loader.getString("GS_TYPE");
        if (!"SECONDS".equals(string)) {
            throw new FactoryException(Errors.format(12, "GS_TYPE", string));
        }
        this.gridFile = (String)nTv2Loader.latitudeGridFile;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return NTv2.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup parameterValueGroup = this.getParameterDescriptors().createValue();
        Parameters.getOrCreate(NTv2.DIFFERENCE_FILE, parameterValueGroup).setValue(this.gridFile);
        return parameterValueGroup;
    }
}

