/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.number;

import net.sf.saxon.number.AbstractNumberer;

public class Numberer_da
extends AbstractNumberer {
    private static final long serialVersionUID = 1L;
    private static String[] danishOrdinalUnits = new String[]{"", "f\ufffdrste", "anden", "tredje", "fjerde", "femte", "sjette", "syvende", "ottende", "niende", "tiende", "\ufffdlfte", "tolvte", "trettende", "fjortende", "femtende", "sekstende", "syttende", "attende", "nittende"};
    private static String[] danishOrdinalTens = new String[]{"", "tiende", "tyvende", "tredivte", "fyrretyvende", "halvtredsindstyvende", "tresindstyvende", "halvfjerdsindstyvende", "firsindstyvende", "halvfemstyvende"};
    private static String[] danishUnits = new String[]{"", "et", "to", "tre", "fire", "fem", "seks", "syv", "otte", "ni", "ti", "elleve", "tolv", "tretten", "fjorten", "femten", "seksten", "sytten", "atten", "nitten"};
    private static String[] danishTens = new String[]{"", "ti", "tyve", "tredive", "fyrre", "halvtreds", "tres", "halvfjerds", "firs", "halvfems"};
    private static String[] swedishMonths = new String[]{"januar", "februar", "marts", "april", "maj", "juni", "juli", "august", "september", "oktober", "november", "december"};
    private static String[] danishDays = new String[]{"mandag", "tirsdag", "onsdag", "torsdag", "fredag", "l\ufffdrdag", "s\ufffdndag"};
    private static String[] swedishDayAbbreviations = new String[]{"ma", "ti", "on", "to", "fr", "l\ufffd", "s\ufffd"};
    private static int[] minUniqueDayLength = new int[]{1, 2, 1, 2, 1, 2, 2};

    public String toOrdinalWords(String ordinalParam, long number, int wordCase) {
        String s;
        if (number == 1000000000L) {
            s = "millardte";
        } else if (number == 1000000L) {
            s = "millonte";
        } else if (number == 1000L) {
            s = "tusinde";
        } else if (number == 100L) {
            s = "hundrede";
        } else if (number >= 1000000000L) {
            long rem = number % 1000000000L;
            s = (number / 1000000000L == 1L ? "en" : this.toWords(number / 1000000000L)) + " milliard " + this.toOrdinalWords(ordinalParam, rem, wordCase);
        } else if (number >= 1000000L) {
            long rem = number % 1000000L;
            s = (number / 1000000L == 1L ? "en" : this.toWords(number / 1000000L)) + " million " + this.toOrdinalWords(ordinalParam, rem, wordCase);
        } else if (number >= 1000L) {
            long rem = number % 1000L;
            s = (number / 1000L == 1L ? "et" : this.toWords(number / 1000L)) + "tusind" + " " + this.toOrdinalWords(ordinalParam, rem, wordCase);
        } else if (number >= 100L) {
            long rem = number % 100L;
            s = (number / 100L == 1L ? "" : this.toWords(number / 100L)) + "hundred" + (rem == 0L || rem > 19L ? "" : "en") + this.toOrdinalWords(ordinalParam, rem, wordCase);
        } else {
            int rem;
            s = number < 20L ? danishOrdinalUnits[(int)number] : ((rem = (int)(number % 10L)) == 0 ? danishOrdinalTens[(int)number / 10] : danishTens[(int)number / 10] + danishOrdinalUnits[rem]);
        }
        if (wordCase == 0) {
            return s.toUpperCase();
        }
        if (wordCase == 1) {
            return s.toLowerCase();
        }
        return s;
    }

    public String toWords(long number) {
        if (number >= 1000000000L) {
            long rem = number % 1000000000L;
            return (number / 1000000000L == 1L ? "en " : this.toWords(number / 1000000000L)) + "milliard" + (rem == 0L ? "" : " ") + this.toWords(rem);
        }
        if (number >= 1000000L) {
            long rem = number % 1000000L;
            return (number / 1000000L == 1L ? "en " : this.toWords(number / 1000000L)) + "million" + (rem == 0L ? "" : " ") + this.toWords(rem);
        }
        if (number >= 1000L) {
            long rem = number % 1000L;
            return this.toWords(number / 1000L) + "tusind" + (rem == 0L ? "" : " ") + this.toWords(rem);
        }
        if (number >= 100L) {
            long rem = number % 100L;
            return this.toWords(number / 100L) + "hundred" + (rem > 0L ? "og" + this.toWords(rem) : "");
        }
        if (number < 20L) {
            return danishUnits[(int)number];
        }
        int rem = (int)(number % 10L);
        return danishUnits[rem] + "og" + danishTens[(int)number / 10];
    }

    public String toWords(long number, int wordCase) {
        String s = number == 0L ? "nul" : this.toWords(number);
        if (wordCase == 0) {
            return s.toUpperCase();
        }
        if (wordCase == 1) {
            return s.toLowerCase();
        }
        return s;
    }

    public String monthName(int month, int minWidth, int maxWidth) {
        String name = swedishMonths[month - 1];
        if (maxWidth < 3) {
            maxWidth = 3;
        }
        if (name.length() > maxWidth) {
            name = name.substring(0, maxWidth);
        }
        while (name.length() < minWidth) {
            name = name + ' ';
        }
        return name;
    }

    public String dayName(int day, int minWidth, int maxWidth) {
        String name = danishDays[day - 1];
        if (maxWidth < 2) {
            maxWidth = 2;
        }
        if (name.length() > maxWidth && (name = swedishDayAbbreviations[day - 1]).length() > maxWidth) {
            name = name.substring(0, maxWidth);
        }
        while (name.length() < minWidth) {
            name = name + ' ';
        }
        if (minWidth == 1 && maxWidth == 2) {
            name = name.substring(0, minUniqueDayLength[day - 1]);
        }
        return name;
    }
}

