/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.Serializable;
import java.util.HashMap;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.UnionPattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.XPathException;

public final class RuleManager
implements Serializable {
    private Mode defaultMode;
    private HashMap modes;
    private Mode omniMode = null;

    public RuleManager() {
        this.resetHandlers();
    }

    public void resetHandlers() {
        this.defaultMode = new Mode(-1, Mode.DEFAULT_MODE_NAME);
        this.modes = new HashMap(5);
    }

    public Mode getDefaultMode() {
        return this.defaultMode;
    }

    public Mode getMode(StructuredQName modeName, boolean createIfAbsent) {
        if (modeName == null || modeName.equals(Mode.DEFAULT_MODE_NAME)) {
            return this.defaultMode;
        }
        if (modeName.equals(Mode.ALL_MODES)) {
            if (this.omniMode == null) {
                this.omniMode = new Mode(-3, modeName);
            }
            return this.omniMode;
        }
        Mode m = (Mode)this.modes.get(modeName);
        if (m == null && createIfAbsent) {
            m = new Mode(this.omniMode, modeName);
            this.modes.put(modeName, m);
        }
        return m;
    }

    public void setHandler(Pattern pattern, Template eh, Mode mode, int precedence) {
        if (pattern instanceof UnionPattern) {
            UnionPattern up = (UnionPattern)pattern;
            Pattern p1 = up.getLHS();
            Pattern p2 = up.getRHS();
            this.setHandler(p1, eh, mode, precedence);
            this.setHandler(p2, eh, mode, precedence);
            return;
        }
        double priority = pattern.getDefaultPriority();
        this.setHandler(pattern, eh, mode, precedence, priority);
    }

    public void setHandler(Pattern pattern, Template eh, Mode mode, int precedence, double priority) {
        if (pattern instanceof UnionPattern) {
            UnionPattern up = (UnionPattern)pattern;
            Pattern p1 = up.getLHS();
            Pattern p2 = up.getRHS();
            this.setHandler(p1, eh, mode, precedence, priority);
            this.setHandler(p2, eh, mode, precedence, priority);
            return;
        }
        mode.addRule(pattern, eh, precedence, priority, true);
        if (mode == this.omniMode) {
            this.defaultMode.addRule(pattern, eh, precedence, priority, false);
            for (Mode m : this.modes.values()) {
                m.addRule(pattern, eh, precedence, priority, false);
            }
        }
    }

    public Rule getTemplateRule(NodeInfo node, Mode mode, XPathContext c) throws XPathException {
        if (mode == null) {
            mode = this.defaultMode;
        }
        return mode.getRule(node, c);
    }

    public Rule getTemplateRule(NodeInfo node, Mode mode, int min, int max, XPathContext c) throws XPathException {
        if (mode == null) {
            mode = this.defaultMode;
        }
        return mode.getRule(node, min, max, c);
    }

    public Rule getNextMatchHandler(NodeInfo node, Mode mode, Rule currentRule, XPathContext c) throws XPathException {
        if (mode == null) {
            mode = this.defaultMode;
        }
        return mode.getNextMatchRule(node, currentRule, c);
    }

    public void explainTemplateRules(ExpressionPresenter presenter) {
        presenter.startElement("templateRules");
        this.defaultMode.explainTemplateRules(presenter);
        for (Mode mode : this.modes.values()) {
            int s = presenter.startElement("mode");
            if (!mode.isDefaultMode()) {
                presenter.emitAttribute("name", mode.getModeName().getDisplayName());
            }
            mode.explainTemplateRules(presenter);
            int e = presenter.endElement();
            if (s == e) continue;
            throw new IllegalStateException("tree unbalanced");
        }
        presenter.endElement();
    }
}

