/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.converter;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import org.geotoolkit.lang.Static;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.collection.XCollections;

public final class Numbers
extends Static {
    public static final byte DOUBLE = 8;
    public static final byte FLOAT = 7;
    public static final byte LONG = 6;
    public static final byte INTEGER = 5;
    public static final byte SHORT = 4;
    public static final byte BYTE = 3;
    public static final byte CHARACTER = 2;
    public static final byte BOOLEAN = 1;
    public static final byte OTHER = 0;
    private static final Map<Class<?>, Numbers> MAPPING = new HashMap(16);
    private final Class<?> primitive;
    private final Class<?> wrapper;
    private final boolean isFloat;
    private final boolean isInteger;
    private final byte size;
    private final byte ordinal;
    private final char internal;
    private final Object nullValue;

    private Numbers(Class<?> clazz, boolean bl, boolean bl2, byte by) {
        this.wrapper = clazz;
        this.primitive = this.wrapper;
        this.isFloat = bl;
        this.isInteger = bl2;
        this.size = (byte)-1;
        this.ordinal = by;
        this.internal = (char)76;
        this.nullValue = null;
        if (MAPPING.put(clazz, this) != null) {
            throw new AssertionError();
        }
    }

    private Numbers(Class<?> clazz, Class<?> clazz2, boolean bl, boolean bl2, byte by, byte by2, char c, Object object) {
        this.primitive = clazz;
        this.wrapper = clazz2;
        this.isFloat = bl;
        this.isInteger = bl2;
        this.size = by;
        this.ordinal = by2;
        this.internal = c;
        this.nullValue = object;
        if (MAPPING.put(clazz, this) != null || MAPPING.put(clazz2, this) != null) {
            throw new AssertionError();
        }
    }

    static char getInternal(Class<?> clazz) {
        return Numbers.MAPPING.get(clazz).internal;
    }

    public static boolean isFloat(Class<?> clazz) {
        Numbers numbers = MAPPING.get(clazz);
        return numbers != null && numbers.isFloat;
    }

    public static boolean isInteger(Class<?> clazz) {
        Numbers numbers = MAPPING.get(clazz);
        return numbers != null && numbers.isInteger;
    }

    private static boolean isPrimitiveInteger(Class<?> clazz) {
        Numbers numbers = MAPPING.get(clazz);
        return numbers != null && numbers.isInteger && numbers.internal != 'L';
    }

    public static int primitiveBitCount(Class<?> clazz) throws IllegalArgumentException {
        byte by;
        Numbers numbers = MAPPING.get(clazz);
        if (numbers != null && (by = numbers.size) >= 0) {
            return by;
        }
        if (clazz == null) {
            return 0;
        }
        throw Numbers.unknownType(clazz);
    }

    public static Class<?> primitiveToWrapper(Class<?> clazz) {
        Numbers numbers = MAPPING.get(clazz);
        return numbers != null ? numbers.wrapper : clazz;
    }

    public static Class<?> wrapperToPrimitive(Class<?> clazz) {
        Numbers numbers = MAPPING.get(clazz);
        return numbers != null ? numbers.primitive : clazz;
    }

    public static Class<? extends Number> widestClass(Number number, Number number2) throws IllegalArgumentException {
        return Numbers.widestClass(number != null ? number.getClass() : null, number2 != null ? number2.getClass() : null);
    }

    public static Class<? extends Number> widestClass(Class<? extends Number> clazz, Class<? extends Number> clazz2) throws IllegalArgumentException {
        Numbers numbers = MAPPING.get(clazz);
        if (numbers == null && clazz != null) {
            throw Numbers.unknownType(clazz);
        }
        Numbers numbers2 = MAPPING.get(clazz2);
        if (numbers2 == null && clazz2 != null) {
            throw Numbers.unknownType(clazz2);
        }
        if (clazz == null) {
            return clazz2;
        }
        if (clazz2 == null) {
            return clazz;
        }
        return numbers.ordinal >= numbers2.ordinal ? clazz : clazz2;
    }

    public static Class<? extends Number> finestClass(Number number, Number number2) throws IllegalArgumentException {
        return Numbers.finestClass(number != null ? number.getClass() : null, number2 != null ? number2.getClass() : null);
    }

    public static Class<? extends Number> finestClass(Class<? extends Number> clazz, Class<? extends Number> clazz2) throws IllegalArgumentException {
        Numbers numbers = MAPPING.get(clazz);
        if (numbers == null && clazz != null) {
            throw Numbers.unknownType(clazz);
        }
        Numbers numbers2 = MAPPING.get(clazz2);
        if (numbers2 == null && clazz2 != null) {
            throw Numbers.unknownType(clazz2);
        }
        if (clazz == null) {
            return clazz2;
        }
        if (clazz2 == null) {
            return clazz;
        }
        return numbers.ordinal < numbers2.ordinal ? clazz : clazz2;
    }

    public static Class<? extends Number> finestClass(Number number) {
        if (number == null) {
            return null;
        }
        if (Numbers.isPrimitiveInteger(number.getClass())) {
            return Numbers.finestClass(number.longValue());
        }
        return Numbers.finestClass(number.doubleValue());
    }

    public static Class<? extends Number> finestClass(double d) {
        long l = (long)d;
        if (d == (double)l) {
            return Numbers.finestClass(l);
        }
        float f = (float)d;
        if (Double.doubleToRawLongBits(d) == Double.doubleToRawLongBits(f)) {
            return Float.class;
        }
        return Double.class;
    }

    public static Class<? extends Number> finestClass(long l) {
        if (l <= 127L && l >= -128L) {
            return Byte.class;
        }
        if (l <= 32767L && l >= -32768L) {
            return Short.class;
        }
        if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
            return Integer.class;
        }
        return Long.class;
    }

    public static Number finestNumber(Number number) {
        if (number == null) {
            return null;
        }
        Number number2 = Numbers.isPrimitiveInteger(number.getClass()) ? (Number)Numbers.finestNumber(number.longValue()) : (Number)Numbers.finestNumber(number.doubleValue());
        return number.equals(number2) ? (Number)number : (Number)number2;
    }

    public static Number finestNumber(double d) {
        long l = (long)d;
        if (d == (double)l) {
            return Numbers.finestNumber(l);
        }
        float f = (float)d;
        if (Double.doubleToRawLongBits(d) == Double.doubleToRawLongBits(f)) {
            return Float.valueOf(f);
        }
        return d;
    }

    public static Number finestNumber(long l) {
        if (l <= 127L && l >= -128L) {
            return (byte)l;
        }
        if (l <= 32767L && l >= -32768L) {
            return (short)l;
        }
        if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
            return (int)l;
        }
        return l;
    }

    public static Number finestNumber(String string) throws NumberFormatException {
        string = string.trim();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != '.' && c != 'e' && c != 'E') continue;
            return Numbers.finestNumber(Double.parseDouble(string));
        }
        return Numbers.finestNumber(Long.parseLong(string));
    }

    public static <N extends Number> N cast(Number number, Class<N> clazz) throws IllegalArgumentException {
        if (number == null || number.getClass() == clazz) {
            return (N)number;
        }
        if (clazz == Byte.class) {
            return (N)Byte.valueOf(number.byteValue());
        }
        if (clazz == Short.class) {
            return (N)Short.valueOf(number.shortValue());
        }
        if (clazz == Integer.class) {
            return (N)Integer.valueOf(number.intValue());
        }
        if (clazz == Long.class) {
            return (N)Long.valueOf(number.longValue());
        }
        if (clazz == Float.class) {
            return (N)Float.valueOf(number.floatValue());
        }
        if (clazz == Double.class) {
            return (N)Double.valueOf(number.doubleValue());
        }
        throw Numbers.unknownType(clazz);
    }

    public static <T> T valueOf(Class<T> clazz, String string) throws IllegalArgumentException, NumberFormatException {
        if (string == null) {
            return null;
        }
        if (clazz == Double.class) {
            return (T)Double.valueOf(string);
        }
        if (clazz == Float.class) {
            return (T)Float.valueOf(string);
        }
        if (clazz == Long.class) {
            return (T)Long.valueOf(string);
        }
        if (clazz == Integer.class) {
            return (T)Integer.valueOf(string);
        }
        if (clazz == Short.class) {
            return (T)Short.valueOf(string);
        }
        if (clazz == Byte.class) {
            return (T)Byte.valueOf(string);
        }
        if (clazz == Boolean.class) {
            return (T)Boolean.valueOf(string);
        }
        if (clazz == Character.class) {
            return (T)Character.valueOf(string.isEmpty() ? (char)'\u0000' : string.charAt(0));
        }
        if (clazz == String.class) {
            return (T)string;
        }
        throw Numbers.unknownType(clazz);
    }

    public static <T> T valueOfNil(Class<T> clazz) {
        if (clazz.isPrimitive()) {
            return (T)Numbers.MAPPING.get(clazz).nullValue;
        }
        if (clazz == Map.class) {
            return (T)Collections.EMPTY_MAP;
        }
        if (clazz == List.class) {
            return (T)Collections.EMPTY_LIST;
        }
        if (clazz == Queue.class) {
            return (T)XCollections.emptyQueue();
        }
        if (clazz == SortedSet.class) {
            return (T)XCollections.emptySortedSet();
        }
        if (clazz != null && clazz != Object.class) {
            if (clazz.isAssignableFrom(Set.class)) {
                return (T)Collections.EMPTY_SET;
            }
            Class<?> clazz2 = clazz.getComponentType();
            if (clazz2 != null) {
                return (T)Array.newInstance(clazz2, 0);
            }
        }
        return null;
    }

    public static byte getEnumConstant(Class<?> clazz) {
        Numbers numbers = MAPPING.get(clazz);
        if (numbers != null && numbers.size >= 0) {
            return numbers.ordinal;
        }
        return 0;
    }

    private static IllegalArgumentException unknownType(Class<?> clazz) {
        return new IllegalArgumentException(Errors.format(226, clazz));
    }

    static {
        new Numbers(BigDecimal.class, true, false, 10);
        new Numbers(BigInteger.class, false, true, 9);
        new Numbers(Double.TYPE, Double.class, true, false, 64, 8, 'D', Double.NaN);
        new Numbers(Float.TYPE, Float.class, true, false, 32, 7, 'F', Float.valueOf(Float.NaN));
        new Numbers(Long.TYPE, Long.class, false, true, 64, 6, 'J', 0L);
        new Numbers(Integer.TYPE, Integer.class, false, true, 32, 5, 'I', 0);
        new Numbers(Short.TYPE, Short.class, false, true, 16, 4, 'S', (short)0);
        new Numbers(Byte.TYPE, Byte.class, false, true, 8, 3, 'B', (byte)0);
        new Numbers(Character.TYPE, Character.class, false, false, 16, 2, 'C', Character.valueOf('\u0000'));
        new Numbers(Boolean.TYPE, Boolean.class, false, false, 1, 1, 'Z', Boolean.FALSE);
        new Numbers(Void.TYPE, Void.class, false, false, 0, 0, 'V', null);
    }
}

