/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory.wkt;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.io.TableWriter;
import org.geotoolkit.metadata.iso.DefaultIdentifier;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.metadata.iso.citation.DefaultCitation;
import org.geotoolkit.referencing.factory.wkt.SpatialRefSysMap;
import org.geotoolkit.referencing.factory.wkt.WKTParsingAuthorityFactory;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.logging.Logging;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

public class DirectPostgisFactory
extends WKTParsingAuthorityFactory
implements CRSAuthorityFactory {
    public static final String TABLE = "spatial_ref_sys";
    public static final String PRIMARY_KEY = "srid";
    public static final String AUTHORITY_COLUMN = "auth_name";
    public static final String CODE_COLUMN = "auth_srid";
    public static final String WKT_COLUMN = "srtext";
    private transient Map<String, Boolean> authorityUsePK;

    public DirectPostgisFactory(Hints hints, Connection connection) throws SQLException {
        super(hints, new SpatialRefSysMap(connection));
    }

    @Override
    public String getBackingStoreDescription() throws FactoryException {
        String string;
        Citation citation = this.getAuthority();
        TableWriter tableWriter = new TableWriter(null, " ");
        Vocabulary vocabulary = Vocabulary.getResources(null);
        InternationalString internationalString = citation.getEdition();
        if (internationalString != null) {
            string = Citations.getIdentifier((Citation)citation);
            tableWriter.write(vocabulary.getString(323, (Object)string));
            tableWriter.write(58);
            tableWriter.nextColumn();
            tableWriter.write(((Object)internationalString).toString());
            tableWriter.nextLine();
        }
        try {
            DatabaseMetaData databaseMetaData = ((SpatialRefSysMap)this.definitions).connection.getMetaData();
            string = databaseMetaData.getDatabaseProductName();
            if (string != null) {
                tableWriter.write(vocabulary.getLabel(55));
                tableWriter.nextColumn();
                tableWriter.write(string);
                string = databaseMetaData.getDatabaseProductVersion();
                if (string != null) {
                    tableWriter.write(32);
                    tableWriter.write(vocabulary.getString(322, (Object)string));
                }
                tableWriter.nextLine();
            }
            if ((string = databaseMetaData.getURL()) != null) {
                tableWriter.write(vocabulary.getLabel(56));
                tableWriter.nextColumn();
                tableWriter.write(string);
                tableWriter.nextLine();
            }
        }
        catch (SQLException sQLException) {
            throw DirectPostgisFactory.databaseFailure(null, null, sQLException);
        }
        return tableWriter.toString();
    }

    @Override
    public Citation getPrimaryKeyAuthority() {
        return Citations.POSTGIS;
    }

    @Override
    final synchronized Citation[] getAuthorities() {
        Citation[] citationArray = this.authorities;
        if (citationArray == null) {
            Citation citation = this.getPrimaryKeyAuthority();
            int n = 0;
            try {
                Set<String> set = this.getAuthorityNames().keySet();
                citationArray = new Citation[set.size() + 1];
                for (String string : set) {
                    Citation citation2;
                    Citation citation3 = citation2 = string != null ? Citations.fromName((String)string) : citation;
                    if (citation2.getClass() == DefaultCitation.class) {
                        ((DefaultCitation)citation2).getIdentifiers().add(new DefaultIdentifier(string));
                    }
                    citationArray[n++] = citation2;
                }
            }
            catch (FactoryException factoryException) {
                Logging.unexpectedException((Logger)LOGGER, DirectPostgisFactory.class, (String)"getAuthority", (Throwable)factoryException);
                citationArray = new Citation[]{this.getPrimaryKeyAuthority()};
            }
            citationArray[n] = citation;
            this.authorities = citationArray;
        }
        return citationArray;
    }

    private Map<String, Boolean> getAuthorityNames() throws FactoryException {
        assert (Thread.holdsLock(this));
        if (this.authorityUsePK == null) {
            try {
                this.authorityUsePK = ((SpatialRefSysMap)this.definitions).getAuthorityNames();
            }
            catch (SQLException sQLException) {
                throw DirectPostgisFactory.databaseFailure(null, null, sQLException);
            }
        }
        return this.authorityUsePK;
    }

    @Override
    public synchronized Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> clazz) throws FactoryException {
        try {
            return ((SpatialRefSysMap)this.definitions).getAuthorityCodes(clazz);
        }
        catch (SQLException sQLException) {
            throw DirectPostgisFactory.databaseFailure(clazz, null, sQLException);
        }
    }

    public synchronized Integer getPrimaryKey(Class<? extends IdentifiedObject> clazz, String string) throws NoSuchAuthorityCodeException, FactoryException {
        Integer n;
        int n2;
        DirectPostgisFactory.ensureNonNull("code", string);
        string = string.trim();
        int n3 = string.lastIndexOf(58);
        String string2 = n3 >= 0 ? string.substring(0, n3).trim() : "";
        String string3 = string.substring(n3 + 1).trim();
        try {
            n2 = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            NoSuchAuthorityCodeException noSuchAuthorityCodeException = this.noSuchAuthorityCode(IdentifiedObject.class, string);
            noSuchAuthorityCodeException.initCause(numberFormatException);
            throw noSuchAuthorityCodeException;
        }
        if (string2.isEmpty() || Boolean.TRUE.equals(this.getAuthorityNames().get(string2))) {
            return n2;
        }
        try {
            n = ((SpatialRefSysMap)this.definitions).getPrimaryKey(string, string2, n2);
        }
        catch (SQLException sQLException) {
            throw DirectPostgisFactory.databaseFailure(clazz, string, sQLException);
        }
        if (n == null) {
            throw this.noSuchAuthorityCode(clazz, string);
        }
        return n;
    }

    @Override
    protected synchronized void dispose(boolean bl) {
        try {
            ((SpatialRefSysMap)this.definitions).dispose();
        }
        catch (SQLException sQLException) {
            Logging.unexpectedException(DirectPostgisFactory.class, (String)"dispose", (Throwable)sQLException);
        }
        this.authority = null;
        this.authorities = null;
        super.dispose(bl);
    }
}

