/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.matrix;

import java.io.Serializable;
import javax.vecmath.SingularMatrixException;
import org.geotoolkit.referencing.operation.matrix.GeneralMatrix;
import org.geotoolkit.referencing.operation.matrix.Matrices;
import org.geotoolkit.referencing.operation.matrix.XMatrix;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.opengis.referencing.operation.Matrix;

public class Matrix2
implements XMatrix,
Serializable {
    private static final long serialVersionUID = 7116561372481474290L;
    public static final int SIZE = 2;
    public double m00;
    public double m01;
    public double m10;
    public double m11;

    public Matrix2() {
        this.m11 = 1.0;
        this.m00 = 1.0;
    }

    public Matrix2(double d, double d2, double d3, double d4) {
        this.m00 = d;
        this.m01 = d2;
        this.m10 = d3;
        this.m11 = d4;
    }

    public Matrix2(double[] dArray) {
        if (dArray.length != 4) {
            throw new IllegalArgumentException(Errors.format((int)109));
        }
        this.m00 = dArray[0];
        this.m01 = dArray[1];
        this.m10 = dArray[2];
        this.m11 = dArray[3];
    }

    public Matrix2(Matrix matrix) throws IllegalArgumentException {
        if (matrix.getNumRow() != 2 || matrix.getNumCol() != 2) {
            throw new IllegalArgumentException(Errors.format((int)85));
        }
        this.m00 = matrix.getElement(0, 0);
        this.m01 = matrix.getElement(0, 1);
        this.m10 = matrix.getElement(1, 0);
        this.m11 = matrix.getElement(1, 1);
    }

    @Override
    public final int getNumRow() {
        return 2;
    }

    @Override
    public final int getNumCol() {
        return 2;
    }

    @Override
    public final double getElement(int n, int n2) {
        switch (n) {
            case 0: {
                switch (n2) {
                    case 0: {
                        return this.m00;
                    }
                    case 1: {
                        return this.m01;
                    }
                }
                break;
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        return this.m10;
                    }
                    case 1: {
                        return this.m11;
                    }
                }
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final void setElement(int n, int n2, double d) {
        switch (n) {
            case 0: {
                switch (n2) {
                    case 0: {
                        this.m00 = d;
                        return;
                    }
                    case 1: {
                        this.m01 = d;
                        return;
                    }
                }
                break;
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        this.m10 = d;
                        return;
                    }
                    case 1: {
                        this.m11 = d;
                        return;
                    }
                }
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final void setZero() {
        this.m11 = 0.0;
        this.m10 = 0.0;
        this.m01 = 0.0;
        this.m00 = 0.0;
    }

    @Override
    public final void setIdentity() {
        this.m10 = 0.0;
        this.m01 = 0.0;
        this.m11 = 1.0;
        this.m00 = 1.0;
        assert (this.isIdentity());
    }

    @Override
    public final boolean isIdentity() {
        return this.m01 == 0.0 && this.m10 == 0.0 && this.m00 == 1.0 && this.m11 == 1.0;
    }

    @Override
    public final boolean isIdentity(double d) {
        return GeneralMatrix.isIdentity(this, d);
    }

    @Override
    public final boolean isAffine() {
        return this.m10 == 0.0 && this.m11 == 1.0;
    }

    @Override
    public final void negate() {
        this.m00 = -this.m00;
        this.m01 = -this.m01;
        this.m10 = -this.m10;
        this.m11 = -this.m11;
    }

    @Override
    public final void transpose() {
        double d = this.m10;
        this.m10 = this.m01;
        this.m01 = d;
    }

    @Override
    public final void invert() throws SingularMatrixException {
        double d = this.m00 * this.m11 - this.m01 * this.m10;
        if (d == 0.0) {
            throw new SingularMatrixException();
        }
        double d2 = this.m00;
        this.m00 = this.m11 / d;
        this.m11 = d2 / d;
        this.m10 = -this.m10 / d;
        this.m01 = -this.m01 / d;
    }

    @Override
    public final void multiply(Matrix matrix) {
        Matrix2 matrix2 = matrix instanceof Matrix2 ? (Matrix2)matrix : new Matrix2(matrix);
        double d = this.m00;
        double d2 = this.m01;
        this.m00 = d * matrix2.m00 + d2 * matrix2.m10;
        this.m01 = d * matrix2.m01 + d2 * matrix2.m11;
        d = this.m10;
        d2 = this.m11;
        this.m10 = d * matrix2.m00 + d2 * matrix2.m10;
        this.m11 = d * matrix2.m01 + d2 * matrix2.m11;
    }

    @Override
    public final void normalizeColumns() {
        double d = Math.hypot(this.m00, this.m10);
        this.m00 /= d;
        this.m10 /= d;
        d = Math.hypot(this.m01, this.m11);
        this.m01 /= d;
        this.m11 /= d;
    }

    @Override
    public boolean equals(Matrix matrix, double d) {
        return Matrices.equals(this, matrix, d, false);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        return object instanceof Matrix && Matrices.equals(this, (Matrix)object, comparisonMode);
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            Matrix2 matrix2 = (Matrix2)object;
            return Utilities.equals((double)this.m00, (double)matrix2.m00) && Utilities.equals((double)this.m01, (double)matrix2.m01) && Utilities.equals((double)this.m10, (double)matrix2.m10) && Utilities.equals((double)this.m11, (double)matrix2.m11);
        }
        return false;
    }

    public int hashCode() {
        long l = 0x62C31ADCF5064EF2L ^ Double.doubleToLongBits(this.m00) + 31L * Double.doubleToLongBits(this.m01) + 31L * Double.doubleToLongBits(this.m10) + 31L * Double.doubleToLongBits(this.m11);
        return (int)l ^ (int)(l >>> 32);
    }

    public String toString() {
        return GeneralMatrix.toString(this);
    }

    @Override
    public Matrix2 clone() {
        try {
            return (Matrix2)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }
}

