/*
 * Decompiled with CFR 0.152.
 */
package com.bric.geom;

import com.bric.geom.SimplifiedPathIterator;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;

public class RectangleReader {
    private static final double TOL = 1.0E-12;

    public static boolean isRectangle(Shape s2) {
        return RectangleReader.convert(s2) != null;
    }

    public static boolean isRectangle(Shape s2, AffineTransform tx) {
        return RectangleReader.convert(s2, tx) != null;
    }

    public static final Rectangle2D convert(Shape shape) {
        return RectangleReader.convert(shape, null);
    }

    public static final Rectangle2D convert(Shape shape, AffineTransform transform) {
        int k;
        if (shape == null) {
            return null;
        }
        if (transform != null && transform.isIdentity()) {
            transform = null;
        }
        if (shape instanceof Rectangle && transform == null) {
            return (Rectangle)shape;
        }
        if (shape instanceof Rectangle2D && transform == null) {
            Rectangle2D rect = (Rectangle2D)shape;
            return RectangleReader.getRectangle(rect);
        }
        double[] data = new double[6];
        double lastX = 0.0;
        double lastY = 0.0;
        PathIterator i = shape.getPathIterator(transform);
        double left = 0.0;
        double right = 0.0;
        double top = 0.0;
        double bottom = 0.0;
        boolean defined = false;
        double moveX = 0.0;
        double moveY = 0.0;
        while (!i.isDone()) {
            k = i.currentSegment(data);
            if ((k = SimplifiedPathIterator.simplify(k, lastX, lastY, data)) == 4) {
                k = 1;
                data[0] = moveX;
                data[1] = moveY;
            }
            if (k == 0) {
                moveX = data[0];
                moveY = data[1];
                lastX = data[0];
                lastY = data[1];
                if (defined) {
                    return null;
                }
            } else if (k != 4) {
                if (k == 1) {
                    if (!defined) {
                        left = right = lastX;
                        top = bottom = lastY;
                        defined = true;
                    } else {
                        if (lastX < left) {
                            left = lastX;
                        }
                        if (lastY < top) {
                            top = lastY;
                        }
                        if (lastX > right) {
                            right = lastX;
                        }
                        if (lastY > bottom) {
                            bottom = lastY;
                        }
                        if (lastX != data[0] && lastY != data[1]) {
                            return null;
                        }
                    }
                    if (data[0] < left) {
                        left = data[0];
                    }
                    if (data[1] < top) {
                        top = data[1];
                    }
                    if (data[0] > right) {
                        right = data[0];
                    }
                    if (data[1] > bottom) {
                        bottom = data[1];
                    }
                    lastX = data[0];
                    lastY = data[1];
                } else {
                    return null;
                }
            }
            i.next();
        }
        if (!defined) {
            return null;
        }
        if (lastX != moveX && lastY != moveY) {
            return null;
        }
        i = shape.getPathIterator(transform);
        while (!i.isDone()) {
            k = i.currentSegment(data);
            if ((k = SimplifiedPathIterator.simplify(k, lastX, lastY, data)) == 0) {
                lastX = data[0];
                lastY = data[1];
            } else if (k == 1) {
                double midX = (data[0] + lastX) / 2.0;
                double midY = (data[1] + lastY) / 2.0;
                if (data[1] == top) {
                    if (!SimplifiedPathIterator.collinear(left, top, right, top, data[0], data[1])) {
                        return null;
                    }
                } else if (data[1] == bottom) {
                    if (!SimplifiedPathIterator.collinear(left, bottom, right, bottom, data[0], data[1])) {
                        return null;
                    }
                } else if (data[0] == left) {
                    if (!SimplifiedPathIterator.collinear(left, top, left, bottom, data[0], data[1])) {
                        return null;
                    }
                } else if (data[0] == right) {
                    if (!SimplifiedPathIterator.collinear(right, top, right, bottom, data[0], data[1])) {
                        return null;
                    }
                } else {
                    return null;
                }
                if (midY == top) {
                    if (!SimplifiedPathIterator.collinear(left, top, right, top, midX, midY)) {
                        return null;
                    }
                } else if (midY == bottom) {
                    if (!SimplifiedPathIterator.collinear(left, bottom, right, bottom, midX, midY)) {
                        return null;
                    }
                } else if (midX == left) {
                    if (!SimplifiedPathIterator.collinear(left, top, left, bottom, midX, midY)) {
                        return null;
                    }
                } else if (midX == right) {
                    if (!SimplifiedPathIterator.collinear(right, top, right, bottom, midX, midY)) {
                        return null;
                    }
                } else {
                    return null;
                }
                lastX = data[0];
                lastY = data[1];
            }
            i.next();
        }
        Rectangle intRect = RectangleReader.getRectangle(left, top, right - left, bottom - top);
        if (intRect != null) {
            return intRect;
        }
        return new Rectangle2D.Double(left, top, right - left, bottom - top);
    }

    private static final Rectangle2D getRectangle(Rectangle2D r) {
        double h2;
        double w;
        double y;
        double x = r.getX();
        Rectangle newRect = RectangleReader.getRectangle(x, y = r.getY(), w = r.getWidth(), h2 = r.getHeight());
        if (newRect != null) {
            return newRect;
        }
        return r;
    }

    private static final Rectangle getRectangle(double x, double y, double w, double h2) {
        if (w < 0.0) {
            x += w;
            w = -w;
        }
        if (h2 < 0.0) {
            y += w;
            h2 = -h2;
        }
        int iw = (int)Math.round(w);
        int ih = (int)Math.round(h2);
        if (Math.abs((double)iw - w) > 1.0E-12) {
            return null;
        }
        if (Math.abs((double)ih - h2) > 1.0E-12) {
            return null;
        }
        int ix = (int)Math.round(x);
        int iy = (int)Math.round(y);
        if (Math.abs((double)ix - x) > 1.0E-12) {
            return null;
        }
        if (Math.abs((double)iy - y) > 1.0E-12) {
            return null;
        }
        return new Rectangle(ix, iy, iw, ih);
    }
}

