/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.Collections;
import java.util.Set;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.functions.ConstructorFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.SystemFunctionLibrary;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.XSLTStaticContext;
import net.sf.saxon.sxpath.AbstractStaticContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;

public class UseWhenStaticContext
extends AbstractStaticContext
implements XSLTStaticContext,
Container {
    public NamespaceResolver namespaceContext;
    public FunctionLibrary functionLibrary;
    public StyleNodeFactory nodeFactory;

    public UseWhenStaticContext(Configuration config, NamespaceResolver namespaceContext) {
        this.setConfiguration(config);
        this.namespaceContext = namespaceContext;
        FunctionLibraryList lib = new FunctionLibraryList();
        lib.addFunctionLibrary(SystemFunctionLibrary.getSystemFunctionLibrary(2));
        lib.addFunctionLibrary(this.getConfiguration().getVendorFunctionLibrary());
        lib.addFunctionLibrary(new ConstructorFunctionLibrary(this.getConfiguration()));
        if (config.isAllowExternalFunctions()) {
            Configuration.getPlatform().addFunctionLibraries(lib, config);
        }
        this.functionLibrary = lib;
    }

    public void issueWarning(String s2, SourceLocator locator) {
        XPathException err = new XPathException(s2);
        err.setLocator(locator);
        try {
            this.getConfiguration().getErrorListener().warning(err);
        }
        catch (TransformerException e) {
            // empty catch block
        }
    }

    public String getSystemId() {
        return this.getBaseURI();
    }

    public String getURIForPrefix(String prefix) throws XPathException {
        String uri = this.namespaceContext.getURIForPrefix(prefix, false);
        if (uri == null) {
            XPathException err = new XPathException("Namespace prefix '" + prefix + "' has not been declared");
            err.setErrorCode("XTDE0290");
            throw err;
        }
        return uri;
    }

    public VariableReference bindVariable(StructuredQName qName) throws XPathException {
        XPathException err = new XPathException("Variables cannot be used in a use-when expression");
        err.setErrorCode("XPST0008");
        err.setIsStaticError(true);
        throw err;
    }

    public FunctionLibrary getFunctionLibrary() {
        return this.functionLibrary;
    }

    public StringCollator getCollation(String name) {
        return null;
    }

    public String getDefaultCollationName() {
        return "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    }

    public String getDefaultFunctionNamespace() {
        return "http://www.w3.org/2005/xpath-functions";
    }

    public boolean isInBackwardsCompatibleMode() {
        return false;
    }

    public boolean isImportedSchema(String namespace) {
        return false;
    }

    public Set getImportedSchemaNamespaces() {
        return Collections.EMPTY_SET;
    }

    public boolean isAllowedBuiltInType(BuiltInAtomicType type) {
        return this.getConfiguration().isSchemaAware(50) || type.isAllowedInBasicXSLT();
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceContext;
    }

    public boolean isElementAvailable(String qname) throws XPathException {
        try {
            String[] parts = this.getConfiguration().getNameChecker().getQNameParts(qname);
            String uri = parts[0].length() == 0 ? this.getDefaultElementNamespace() : this.getURIForPrefix(parts[0]);
            if (this.nodeFactory == null) {
                Configuration config = this.getConfiguration();
                this.nodeFactory = new StyleNodeFactory(config, config.getErrorListener());
            }
            return this.nodeFactory.isElementAvailable(uri, parts[1]);
        }
        catch (QNameException e) {
            XPathException err = new XPathException("Invalid element name. " + e.getMessage());
            err.setErrorCode("XTDE1440");
            throw err;
        }
    }
}

