/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.util.Arrays;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridCoverageProcessor;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.referencing.operation.builder.LinearTransformBuilder;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class DomainLinearizer {
    private boolean gridStartsAtZero;
    private double scale = 1.0;
    private GridCoverageProcessor processor;

    public boolean getGridStartsAtZero() {
        return this.gridStartsAtZero;
    }

    public void setGridStartsAtZero(boolean force) {
        this.gridStartsAtZero = force;
    }

    public double getScaleFactor() {
        return this.scale;
    }

    public void setScaleFactor(double factor) {
        ArgumentChecks.ensureStrictlyPositive("factor", factor);
        this.scale = factor;
    }

    private GridCoverageProcessor processor() {
        if (this.processor == null) {
            this.processor = new GridCoverageProcessor();
        }
        return this.processor;
    }

    public GridCoverage apply(GridCoverage coverage) throws TransformException {
        ArgumentChecks.ensureNonNull("coverage", coverage);
        GridGeometry gg = coverage.getGridGeometry();
        GridGeometry linearized = this.apply(gg);
        if (gg.equals(linearized)) {
            return coverage;
        }
        return this.processor().resample(coverage, linearized);
    }

    public GridGeometry apply(GridGeometry gg) throws TransformException {
        ArgumentChecks.ensureNonNull("gg", gg);
        if (gg.nonLinears != 0L) {
            try {
                MathTransform gridToCRS = gg.requireGridToCRS(true);
                GeneralEnvelope domain = gg.extent.toEnvelope();
                MathTransform approximate = this.modify(LinearTransformBuilder.approximate(gridToCRS, domain));
                MathTransform gridToGrid = MathTransforms.concatenate(gridToCRS, approximate.inverse());
                domain = Envelopes.transform(gridToGrid, (Envelope)domain);
                int dimension = domain.getDimension();
                long[] coordinates = new long[dimension * 2];
                double[] shift = new double[dimension];
                for (int i = 0; i < dimension; ++i) {
                    long low = Math.round(domain.getMinimum(i));
                    long high = Math.round(domain.getMaximum(i));
                    high = Math.max(low, Math.decrementExact(high));
                    if (this.gridStartsAtZero) {
                        high = Math.subtractExact(high, low);
                        shift[i] = low;
                    } else {
                        coordinates[i] = low;
                    }
                    coordinates[i + dimension] = high;
                }
                approximate = MathTransforms.concatenate(MathTransforms.translation(shift), approximate);
                if (!approximate.equals(gridToCRS)) {
                    return new GridGeometry(new GridExtent(gg.extent, coordinates), PixelInCell.CELL_CENTER, approximate, gg.envelope.getCoordinateReferenceSystem());
                }
            }
            catch (FactoryException e) {
                Throwable cause = e.getCause();
                if (cause instanceof TransformException) {
                    throw (TransformException)cause;
                }
                throw new TransformException(e);
            }
        }
        return gg;
    }

    private MathTransform modify(LinearTransform gridToCRS) {
        double[] factors = new double[gridToCRS.getTargetDimensions()];
        Arrays.fill(factors, this.scale);
        return MathTransforms.concatenate(MathTransforms.scale(factors), gridToCRS);
    }
}

