/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.image.RenderedImage;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.sis.coverage.BandedCoverage;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.ConvertedGridCoverage;
import org.apache.sis.coverage.grid.DefaultEvaluator;
import org.apache.sis.coverage.grid.FractionalGridCoordinates;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.image.DataType;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.internal.coverage.SampleDimensions;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public abstract class GridCoverage
extends BandedCoverage {
    protected final GridGeometry gridGeometry;
    private final SampleDimension[] sampleDimensions;
    private transient GridCoverage packedView;
    private transient GridCoverage convertedView;

    protected GridCoverage(GridGeometry domain, List<? extends SampleDimension> ranges) {
        this.gridGeometry = domain;
        this.sampleDimensions = (SampleDimension[])ranges.toArray(SampleDimension[]::new);
        ArgumentChecks.ensureNonNull("domain", domain);
        ArgumentChecks.ensureNonEmpty("ranges", this.sampleDimensions);
        for (int i = 0; i < this.sampleDimensions.length; ++i) {
            ArgumentChecks.ensureNonNullElement("ranges", i, this.sampleDimensions[i]);
        }
    }

    GridCoverage(GridCoverage source, GridGeometry domain) {
        this.gridGeometry = domain;
        this.sampleDimensions = source.sampleDimensions;
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.gridGeometry.getCoordinateReferenceSystem();
    }

    @Override
    public Optional<Envelope> getEnvelope() {
        if (this.gridGeometry.isDefined(2)) {
            return Optional.of(this.gridGeometry.getEnvelope());
        }
        return Optional.empty();
    }

    public GridGeometry getGridGeometry() {
        return this.gridGeometry;
    }

    @Override
    public List<SampleDimension> getSampleDimensions() {
        return UnmodifiableArrayList.wrap(this.sampleDimensions);
    }

    private NumberRange<?>[] getRanges() {
        NumberRange[] ranges = null;
        for (int i = 0; i < this.sampleDimensions.length; ++i) {
            Optional<NumberRange<?>> r = this.sampleDimensions[i].getSampleRange();
            if (!r.isPresent()) continue;
            if (ranges == null) {
                ranges = new NumberRange[this.sampleDimensions.length];
            }
            ranges[i] = r.get();
        }
        return ranges;
    }

    final Number[] getBackground() {
        return SampleDimensions.backgrounds(this.sampleDimensions);
    }

    DataType getBandType() {
        return DataType.DOUBLE;
    }

    public synchronized GridCoverage forConvertedValues(boolean converted) {
        GridCoverage view;
        GridCoverage gridCoverage = view = converted ? this.convertedView : this.packedView;
        if (view == null) {
            view = this.createConvertedValues(converted);
            if (converted) {
                this.convertedView = view;
                if (view != this) {
                    view.packedView = this;
                }
            } else {
                this.packedView = view;
                if (view != this) {
                    view.convertedView = this;
                }
            }
        }
        return view;
    }

    protected GridCoverage createConvertedValues(boolean converted) {
        try {
            return ConvertedGridCoverage.create(this, converted);
        }
        catch (NoninvertibleTransformException e) {
            throw new CannotEvaluateException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final RenderedImage convert(RenderedImage source, DataType bandType, MathTransform1D[] converters, ImageProcessor processor) {
        try {
            SampleDimensions.IMAGE_PROCESSOR_ARGUMENT.set(this.sampleDimensions);
            RenderedImage renderedImage = processor.convert(source, this.getRanges(), converters, bandType);
            return renderedImage;
        }
        finally {
            SampleDimensions.IMAGE_PROCESSOR_ARGUMENT.remove();
        }
    }

    @Override
    public Evaluator evaluator() {
        return new DefaultEvaluator(this);
    }

    public abstract RenderedImage render(GridExtent var1) throws CannotEvaluateException;

    public String toString() {
        return this.toTree(Locale.getDefault(), this.gridGeometry.defaultFlags()).toString();
    }

    public TreeTable toTree(Locale locale, int bitmask) {
        ArgumentChecks.ensureNonNull("locale", locale);
        Vocabulary vocabulary = Vocabulary.getResources(locale);
        TableColumn<CharSequence> column = TableColumn.VALUE_AS_TEXT;
        DefaultTreeTable tree = new DefaultTreeTable(column);
        TreeTable.Node root = tree.getRoot();
        root.setValue(column, Classes.getShortClassName(this));
        TreeTable.Node branch = root.newChild();
        branch.setValue(column, vocabulary.getString((short)39));
        this.gridGeometry.formatTo(locale, vocabulary, bitmask, branch);
        this.appendDataLayout(root, vocabulary, column);
        branch = root.newChild();
        branch.setValue(column, vocabulary.getString((short)178));
        branch.newChild().setValue(column, SampleDimension.toString(locale, this.sampleDimensions));
        return tree;
    }

    void appendDataLayout(TreeTable.Node root, Vocabulary vocabulary, TableColumn<CharSequence> column) {
    }

    public static interface Evaluator
    extends BandedCoverage.Evaluator {
        @Override
        public GridCoverage getCoverage();

        public Map<Integer, Long> getDefaultSlice();

        public void setDefaultSlice(Map<Integer, Long> var1);

        public FractionalGridCoordinates toGridCoordinates(DirectPosition var1) throws TransformException;
    }

    static final class Lazy {
        static final ImageProcessor PROCESSOR = new ImageProcessor();

        private Lazy() {
        }
    }
}

