/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DenseFeature;
import org.apache.sis.feature.FeatureFormat;
import org.apache.sis.feature.NamedFeatureType;
import org.apache.sis.feature.SparseFeature;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.Containers;
import org.opengis.feature.AttributeType;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureAssociationRole;
import org.opengis.feature.FeatureInstantiationException;
import org.opengis.feature.FeatureType;
import org.opengis.feature.IdentifiedType;
import org.opengis.feature.Operation;
import org.opengis.feature.PropertyNotFoundException;
import org.opengis.feature.PropertyType;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.util.GenericName;
import org.opengis.util.NameFactory;
import org.opengis.util.ScopedName;

public class DefaultFeatureType
extends AbstractIdentifiedType
implements FeatureType {
    private static final long serialVersionUID = -4357370600723922312L;
    private final boolean isAbstract;
    private transient boolean isSimple;
    private transient boolean isSparse;
    private transient boolean isResolved;
    private final Set<FeatureType> superTypes;
    private transient Set<GenericName> assignableTo;
    private final List<PropertyType> properties;
    private transient Collection<PropertyType> allProperties;
    private transient Map<String, PropertyType> byName;
    private transient Map<String, Integer> indices;
    static final Integer OPERATION_INDEX = -1;

    public DefaultFeatureType(Map<String, ?> identification, boolean isAbstract, FeatureType[] superTypes, PropertyType ... properties) {
        super(identification);
        ArgumentChecks.ensureNonNull("properties", properties);
        this.isAbstract = isAbstract;
        if (superTypes == null) {
            this.superTypes = Collections.emptySet();
        } else {
            this.superTypes = CollectionsExt.immutableSet(true, superTypes);
            for (FeatureType type : this.superTypes) {
                if (!(type instanceof NamedFeatureType)) continue;
                throw new IllegalArgumentException(Resources.format((short)71, type.getName()));
            }
        }
        ArrayList<PropertyType> sourceProperties = new ArrayList<PropertyType>(properties.length);
        for (int i = 0; i < properties.length; ++i) {
            PropertyType property = properties[i];
            ArgumentChecks.ensureNonNullElement("properties", i, property);
            sourceProperties.add(property);
        }
        this.computeTransientFields(sourceProperties);
        int size = sourceProperties.size();
        switch (size) {
            case 0: {
                this.properties = Collections.emptyList();
                break;
            }
            case 1: {
                this.properties = Collections.singletonList((PropertyType)sourceProperties.get(0));
                break;
            }
            default: {
                this.properties = UnmodifiableArrayList.wrap(sourceProperties.toArray(new PropertyType[size]));
            }
        }
        for (PropertyType property : this.allProperties) {
            if (!(property instanceof AbstractOperation)) continue;
            for (String dependency : ((AbstractOperation)property).getDependencies()) {
                if (this.byName.containsKey(dependency)) continue;
                throw new IllegalArgumentException(Resources.format((short)18, property.getName(), dependency, super.getName()));
            }
        }
        this.isResolved = this.resolve(this, this.properties, null, this.isSimple);
    }

    @Override
    GenericName createName(NameFactory factory, String value) {
        return factory.createTypeName(null, value);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.computeTransientFields(this.properties);
        this.isResolved = this.isSimple;
    }

    private void computeTransientFields(List<PropertyType> properties) {
        int capacity = Containers.hashMapCapacity(properties.size());
        this.byName = new LinkedHashMap<String, PropertyType>(capacity);
        this.indices = new LinkedHashMap<String, Integer>(capacity);
        this.assignableTo = new HashSet<GenericName>(4);
        this.assignableTo.add(super.getName());
        this.scanPropertiesFrom(this, properties);
        this.allProperties = UnmodifiableArrayList.wrap((PropertyType[])this.byName.values().toArray(PropertyType[]::new));
        this.isSimple = true;
        int index = 0;
        int mandatory = 0;
        for (Map.Entry<String, PropertyType> entry : this.byName.entrySet()) {
            int maximumOccurs;
            int minimumOccurs;
            PropertyType property = entry.getValue();
            if (property instanceof AttributeType) {
                minimumOccurs = ((AttributeType)property).getMinimumOccurs();
                this.isSimple &= minimumOccurs == (maximumOccurs = ((AttributeType)property).getMaximumOccurs());
            } else if (property instanceof FeatureAssociationRole) {
                minimumOccurs = ((FeatureAssociationRole)property).getMinimumOccurs();
                maximumOccurs = ((FeatureAssociationRole)property).getMaximumOccurs();
                this.isSimple = false;
            } else {
                if (!DefaultFeatureType.isParameterlessOperation(property)) continue;
                this.indices.put(entry.getKey(), OPERATION_INDEX);
                continue;
            }
            if (maximumOccurs == 0) continue;
            this.isSimple &= maximumOccurs == 1;
            this.indices.put(entry.getKey(), index++);
            if (minimumOccurs == 0) continue;
            ++mandatory;
        }
        LinkedHashMap<String, PropertyType> aliases = new LinkedHashMap<String, PropertyType>();
        for (PropertyType property : this.allProperties) {
            String key;
            GenericName name = property.getName();
            while (name instanceof ScopedName && name != (name = ((ScopedName)name).tail()) && (key = name.toString()) != null && !(key = key.trim()).isEmpty()) {
                aliases.put(key, aliases.containsKey(key) ? null : property);
            }
        }
        for (Map.Entry entry : aliases.entrySet()) {
            Integer value;
            String tip;
            PropertyType property = (PropertyType)entry.getValue();
            if (property != null && this.byName.putIfAbsent(tip = (String)entry.getKey(), property) == null && (value = this.indices.get(property.getName().toString())) != null && this.indices.put(tip, value) != null) {
                throw new AssertionError((Object)tip);
            }
        }
        this.byName = CollectionsExt.compact(this.byName);
        this.indices = CollectionsExt.compact(this.indices);
        this.assignableTo = CollectionsExt.unmodifiableOrCopy(this.assignableTo);
        int n = this.indices.size();
        this.isSparse = n > 24 && mandatory <= n / 2;
    }

    private void scanPropertiesFrom(FeatureType source, Collection<? extends PropertyType> sourceProperties) {
        for (FeatureType featureType : source.getSuperTypes()) {
            if (!this.assignableTo.add(featureType.getName())) continue;
            this.scanPropertiesFrom(featureType, featureType.getProperties(false));
        }
        int index = -1;
        Iterator<? extends PropertyType> iterator = sourceProperties.iterator();
        while (iterator.hasNext()) {
            PropertyType property = iterator.next();
            String name = DefaultFeatureType.toString(property.getName(), source, "properties", ++index);
            PropertyType previous = this.byName.put(name, property);
            if (previous == null) continue;
            if (previous.equals(property)) {
                this.byName.put(name, previous);
                if (source != this) continue;
                iterator.remove();
                continue;
            }
            if (DefaultFeatureType.isAssignableIgnoreName(previous, property)) continue;
            GenericName owner = DefaultFeatureType.ownerOf(this, sourceProperties, previous);
            throw new IllegalArgumentException(Resources.format((short)58, owner != null ? owner : "?", name));
        }
    }

    private static GenericName ownerOf(FeatureType type, Collection<? extends PropertyType> properties, PropertyType toSearch) {
        if (properties.contains(toSearch)) {
            return type.getName();
        }
        for (FeatureType featureType : type.getSuperTypes()) {
            GenericName owner = DefaultFeatureType.ownerOf(featureType, featureType.getProperties(false), toSearch);
            if (owner == null) continue;
            return owner;
        }
        return null;
    }

    private boolean resolve(FeatureType feature, Map<FeatureType, Boolean> previous) {
        if (feature instanceof DefaultFeatureType) {
            DefaultFeatureType dt = (DefaultFeatureType)feature;
            dt.isResolved = this.resolve(dt, dt.properties, previous, dt.isResolved);
            return dt.isResolved;
        }
        return this.resolve(feature, feature.getProperties(false), previous, feature.isSimple());
    }

    private boolean resolve(FeatureType feature, Collection<? extends PropertyType> toUpdate, Map<FeatureType, Boolean> previous, boolean resolved) {
        if (!resolved) {
            resolved = true;
            for (FeatureType featureType : feature.getSuperTypes()) {
                resolved &= this.resolve(featureType, previous);
            }
            for (PropertyType propertyType : toUpdate) {
                Boolean r;
                if (!(propertyType instanceof FeatureAssociationRole)) continue;
                if (propertyType instanceof DefaultAssociationRole && !((DefaultAssociationRole)propertyType).resolve(this, this.properties)) {
                    resolved = false;
                    continue;
                }
                FeatureType valueType = ((FeatureAssociationRole)propertyType).getValueType();
                if (valueType == this) continue;
                if (previous == null) {
                    previous = new IdentityHashMap<FeatureType, Boolean>(8);
                }
                if ((r = previous.put(valueType, Boolean.FALSE)) == null) {
                    r = this.resolve(valueType, previous);
                    previous.put(valueType, r);
                }
                resolved &= r.booleanValue();
            }
        }
        return resolved;
    }

    static boolean isParameterlessOperation(PropertyType type) {
        if (type instanceof Operation) {
            ParameterDescriptorGroup parameters = ((Operation)type).getParameters();
            return (parameters == null || parameters.descriptors().isEmpty()) && ((Operation)type).getResult() != null;
        }
        return false;
    }

    @Override
    public final boolean isAbstract() {
        return this.isAbstract;
    }

    final boolean isSparse() {
        return this.isSparse;
    }

    @Override
    public boolean isSimple() {
        return this.isSimple;
    }

    static boolean maybeAssignableFrom(FeatureType base, FeatureType type) {
        if (type instanceof DefaultFeatureType) {
            return ((DefaultFeatureType)type).assignableTo.contains(base.getName());
        }
        if (Objects.equals(base.getName(), type.getName())) {
            return true;
        }
        for (FeatureType featureType : type.getSuperTypes()) {
            if (base != featureType && !DefaultFeatureType.maybeAssignableFrom(base, featureType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAssignableFrom(FeatureType type) {
        if (type == this) {
            return true;
        }
        ArgumentChecks.ensureNonNull("type", type);
        if (!DefaultFeatureType.maybeAssignableFrom(this, type)) {
            return false;
        }
        for (Map.Entry<String, PropertyType> entry : this.byName.entrySet()) {
            PropertyType other;
            try {
                other = type.getProperty(entry.getKey());
            }
            catch (PropertyNotFoundException e) {
                return false;
            }
            if (DefaultFeatureType.isAssignableIgnoreName(entry.getValue(), other)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isAssignableIgnoreName(PropertyType base, PropertyType other) {
        void var3_12;
        int maxOccurs;
        int minOccurs;
        PropertyType p0;
        if (base == other) return true;
        if (base instanceof AttributeType) {
            void var3_5;
            p0 = (AttributeType)base;
            if (other instanceof AttributeType) {
                AttributeType attributeType = (AttributeType)other;
            } else {
                if (!DefaultFeatureType.isParameterlessOperation(other)) return false;
                IdentifiedType result = ((Operation)other).getResult();
                if (!(result instanceof AttributeType)) return false;
                AttributeType attributeType = (AttributeType)result;
            }
            if (!p0.getValueClass().isAssignableFrom(var3_5.getValueClass()) || (minOccurs = p0.getMinimumOccurs()) > var3_5.getMinimumOccurs() || (maxOccurs = p0.getMaximumOccurs()) < var3_5.getMaximumOccurs() || var3_5 != other && (minOccurs > 1 || maxOccurs < 1)) {
                return false;
            }
        }
        if (base instanceof FeatureAssociationRole) {
            FeatureType f1;
            void var3_8;
            p0 = (FeatureAssociationRole)base;
            if (other instanceof FeatureAssociationRole) {
                FeatureAssociationRole featureAssociationRole = (FeatureAssociationRole)other;
            } else {
                if (!DefaultFeatureType.isParameterlessOperation(other)) return false;
                IdentifiedType result = ((Operation)other).getResult();
                if (!(result instanceof FeatureAssociationRole)) return false;
                FeatureAssociationRole featureAssociationRole = (FeatureAssociationRole)result;
            }
            minOccurs = p0.getMinimumOccurs();
            if (minOccurs > var3_8.getMinimumOccurs() || (maxOccurs = p0.getMaximumOccurs()) < var3_8.getMaximumOccurs() || var3_8 != other && (minOccurs > 1 || maxOccurs < 1)) {
                return false;
            }
            FeatureType f0 = p0.getValueType();
            if (f0 != (f1 = var3_8.getValueType()) && !f0.isAssignableFrom(f1)) {
                return false;
            }
        }
        if (!(base instanceof Operation)) return true;
        p0 = (Operation)base;
        if (other instanceof Operation) {
            Operation p1 = (Operation)other;
            if (!Objects.equals(p0.getParameters(), p1.getParameters())) {
                return false;
            }
            IdentifiedType identifiedType = p1.getResult();
        } else {
            if (!DefaultFeatureType.isParameterlessOperation(base)) return false;
            PropertyType propertyType = other;
        }
        IdentifiedType r0 = p0.getResult();
        if (r0 == var3_12) return true;
        if (!(!(r0 instanceof FeatureType) || var3_12 instanceof FeatureType && ((FeatureType)r0).isAssignableFrom((FeatureType)var3_12))) {
            return false;
        }
        if (!(r0 instanceof PropertyType) || var3_12 instanceof PropertyType && DefaultFeatureType.isAssignableIgnoreName((PropertyType)r0, (PropertyType)var3_12)) return true;
        return false;
    }

    public final Set<FeatureType> getSuperTypes() {
        return this.superTypes;
    }

    public Collection<PropertyType> getProperties(boolean includeSuperTypes) {
        return includeSuperTypes ? this.allProperties : this.properties;
    }

    @Override
    public PropertyType getProperty(String name) throws PropertyNotFoundException {
        PropertyType pt = this.byName.get(name);
        if (pt != null) {
            return pt;
        }
        throw new PropertyNotFoundException(AbstractFeature.propertyNotFound(this, this.getName(), name));
    }

    final Map<String, Integer> indices() {
        return this.indices;
    }

    @Override
    public Feature newInstance() throws FeatureInstantiationException {
        if (this.isAbstract) {
            throw new FeatureInstantiationException(Resources.format((short)1, this.getName()));
        }
        return this.isSparse ? new SparseFeature(this) : new DenseFeature(this);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.superTypes.hashCode() + 37 * this.properties.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (super.equals(obj)) {
            DefaultFeatureType that = (DefaultFeatureType)obj;
            return this.isAbstract == that.isAbstract && this.superTypes.equals(that.superTypes) && this.properties.equals(that.properties);
        }
        return false;
    }

    public String toString() {
        return FeatureFormat.sharedFormat(this);
    }
}

