/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.util.Strings;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureInstantiationException;
import org.opengis.feature.FeatureType;
import org.opengis.feature.PropertyNotFoundException;
import org.opengis.feature.PropertyType;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

final class NamedFeatureType
implements FeatureType,
Serializable {
    private static final long serialVersionUID = 178781891980017372L;
    private final GenericName name;
    volatile FeatureType resolved;

    NamedFeatureType(GenericName name) {
        this.name = name;
    }

    @Override
    public GenericName getName() {
        return this.name;
    }

    @Override
    public InternationalString getDefinition() {
        return null;
    }

    @Override
    public boolean isAbstract() {
        return true;
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public PropertyType getProperty(String name) throws PropertyNotFoundException {
        throw new PropertyNotFoundException(Resources.format((short)59, this.getName(), name));
    }

    @Override
    public Collection<? extends PropertyType> getProperties(boolean includeSuperTypes) {
        return Collections.emptySet();
    }

    @Override
    public Set<? extends FeatureType> getSuperTypes() {
        return Collections.emptySet();
    }

    @Override
    public boolean isAssignableFrom(FeatureType type) {
        if (type == this) {
            return true;
        }
        if (type instanceof NamedFeatureType) {
            type = ((NamedFeatureType)type).resolved;
        }
        if (type == null) {
            return false;
        }
        FeatureType resolved = this.resolved;
        return resolved != null && resolved.isAssignableFrom(type);
    }

    @Override
    public Feature newInstance() throws FeatureInstantiationException {
        throw new FeatureInstantiationException(Resources.format((short)71, this.getName()));
    }

    public String toString() {
        return Strings.bracket("FeatureType", (Object)this.name);
    }
}

