/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.feature.builder.PropertyTypeBuilder;
import org.apache.sis.filter.Optimization;
import org.apache.sis.internal.feature.FeatureExpression;
import org.apache.sis.internal.filter.Node;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.apache.sis.util.iso.Names;
import org.apache.sis.util.resources.Errors;
import org.opengis.feature.AttributeType;
import org.opengis.feature.FeatureType;
import org.opengis.filter.Expression;

abstract class LeafExpression<R, V>
extends Node
implements FeatureExpression<R, V> {
    private static final long serialVersionUID = 4262341851590811918L;

    LeafExpression() {
    }

    @Override
    public final List<Expression<R, ?>> getParameters() {
        return List.of();
    }

    @Override
    public Set<FunctionProperty> properties() {
        return Set.of();
    }

    static final class Transformed<R, V>
    extends Literal<R, V>
    implements Optimization.OnExpression<R, V> {
        private static final long serialVersionUID = -5120203649333919221L;
        final Expression<R, ?> original;

        Transformed(V value, Expression<R, ?> original) {
            super(value);
            this.original = original;
        }

        @Override
        public Expression<R, ? extends V> optimize(Optimization optimization) {
            return Optimization.literal(this.getValue());
        }

        @Override
        public <N> Expression<R, N> toValueType(Class<N> target) {
            try {
                N c = ObjectConverters.convert(this.value, target);
                return c != this.value ? new Literal(c) : this;
            }
            catch (UnconvertibleObjectException e) {
                try {
                    return this.original.toValueType(target);
                }
                catch (RuntimeException bis) {
                    ClassCastException c = new ClassCastException(Errors.format((short)8, this.getFunctionName(), target));
                    c.initCause(e);
                    c.addSuppressed(bis);
                    throw c;
                }
            }
        }
    }

    static class Literal<R, V>
    extends LeafExpression<R, V>
    implements org.opengis.filter.Literal<R, V> {
        private static final Set<FunctionProperty> CONSTANT = Set.of(FunctionProperty.ORDER_PRESERVING, FunctionProperty.ORDER_REVERSING);
        private static final long serialVersionUID = -8383113218490957822L;
        protected final V value;
        private static final WeakValueHashMap<Class<?>, AttributeType<?>> TYPES = new WeakValueHashMap(Class.class);

        Literal(V value) {
            this.value = value;
        }

        @Override
        protected Collection<?> getChildren() {
            return Collections.singleton(this.value);
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public Class<?> getValueClass() {
            return this.value != null ? this.value.getClass() : Object.class;
        }

        @Override
        public V apply(Object ignored) {
            return this.value;
        }

        @Override
        public Set<FunctionProperty> properties() {
            return CONSTANT;
        }

        @Override
        public <N> Expression<R, N> toValueType(Class<N> target) {
            try {
                N c = ObjectConverters.convert(this.value, target);
                return c != this.value ? new Literal<R, N>(c) : this;
            }
            catch (UnconvertibleObjectException e) {
                throw (ClassCastException)new ClassCastException(Errors.format((short)8, this.getFunctionName(), target)).initCause(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PropertyTypeBuilder expectedType(FeatureType ignored, FeatureTypeBuilder addTo) {
            AttributeType propertyType;
            Class<?> valueType = this.getValueClass();
            WeakValueHashMap<Class<?>, AttributeType<?>> weakValueHashMap = TYPES;
            synchronized (weakValueHashMap) {
                propertyType = TYPES.get(valueType);
                if (propertyType == null) {
                    Class<?> standardType = Classes.getStandardType(valueType);
                    propertyType = TYPES.computeIfAbsent(standardType, Literal::newType);
                    if (valueType != standardType) {
                        TYPES.put(valueType, propertyType);
                    }
                }
            }
            return addTo.addProperty(propertyType);
        }

        private static <R> AttributeType<R> newType(Class<R> standardType) {
            return Literal.createType(standardType, Names.createLocalName(null, null, "Literal"));
        }
    }
}

