/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.WraparoundAxesFinder;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class WraparoundAdjustment {
    private final ImmutableEnvelope domainOfValidity;
    private AbstractEnvelope shiftableDomain;
    private GeographicBoundingBox geographicDomain;
    private boolean geographicDomainKnown;
    private CoordinateReferenceSystem inputCRS;
    private final CoordinateReferenceSystem resultCRS;
    private MathTransform inputToResult;
    private final MathTransform domainToInput;
    private MathTransform inputToShiftable;
    private MathTransform shiftableToResult;
    private double[] periods;

    public WraparoundAdjustment(Envelope domain, CoordinateReferenceSystem target) {
        ArgumentChecks.ensureNonNull("domain", domain);
        this.domainOfValidity = ImmutableEnvelope.castOrCopy(domain);
        this.resultCRS = target != null ? target : this.domainOfValidity.getCoordinateReferenceSystem();
        this.domainToInput = null;
    }

    public WraparoundAdjustment(Envelope domain, MathTransform domainToInput, MathTransform inputToResult) {
        ArgumentChecks.ensureNonNull("domain", domain);
        this.domainOfValidity = ImmutableEnvelope.castOrCopy(domain);
        if (domainToInput == null) {
            domainToInput = MathTransforms.identity(this.domainOfValidity.getDimension());
        }
        if (inputToResult == null) {
            inputToResult = MathTransforms.identity(domainToInput.getTargetDimensions());
        }
        this.domainToInput = domainToInput;
        this.inputToResult = inputToResult;
        this.resultCRS = null;
    }

    private CoordinateOperation findOperation(CoordinateReferenceSystem source, CoordinateReferenceSystem target) throws TransformException {
        if (!this.geographicDomainKnown && !Utilities.equalsIgnoreMetadata(source, target)) {
            try {
                this.geographicDomainKnown = true;
                this.geographicDomain = ReferencingServices.getInstance().setBounds(this.domainOfValidity, null, null);
            }
            catch (TransformException e) {
                Logging.ignorableException(Envelopes.LOGGER, WraparoundAdjustment.class, "<init>", e);
            }
        }
        try {
            return CRS.findOperation(source, target, this.geographicDomain);
        }
        catch (FactoryException e) {
            throw new TransformException(e);
        }
    }

    private boolean initialize(CoordinateReferenceSystem crs) throws TransformException {
        if (crs == null && (crs = this.domainOfValidity.getCoordinateReferenceSystem()) == null && this.domainToInput == null) {
            this.inputToResult = MathTransforms.identity(this.domainOfValidity.getDimension());
        }
        if (crs != this.inputCRS) {
            this.inputCRS = crs;
            this.periods = null;
            this.inputToShiftable = null;
            this.shiftableToResult = null;
            this.shiftableDomain = this.domainOfValidity;
            if (this.domainToInput == null) {
                this.inputToResult = crs != null && this.resultCRS != null ? this.findOperation(crs, this.resultCRS).getMathTransform() : MathTransforms.identity(crs != null ? ReferencingUtilities.getDimension(crs) : this.domainOfValidity.getDimension());
            }
            if (crs != null) {
                WraparoundAxesFinder f = new WraparoundAxesFinder(crs);
                this.inputToShiftable = f.preferredToSpecified.inverse();
                this.periods = f.periods();
                if (this.periods != null) {
                    this.transformDomain(f.preferredCRS);
                }
            }
        }
        return this.periods != null;
    }

    private void transformDomain(CoordinateReferenceSystem target) throws TransformException {
        if (this.domainToInput != null) {
            MathTransform domainToShiftable = MathTransforms.concatenate(this.domainToInput, this.inputToShiftable);
            if (!domainToShiftable.isIdentity()) {
                this.shiftableDomain = Envelopes.transform(domainToShiftable, (Envelope)this.domainOfValidity);
            }
        } else {
            CoordinateOperation op = this.findOperation(this.domainOfValidity.getCoordinateReferenceSystem(), target);
            MathTransform domainToShiftable = op.getMathTransform();
            if (!domainToShiftable.isIdentity()) {
                this.shiftableDomain = Envelopes.transform(op, (Envelope)this.domainOfValidity);
            }
        }
    }

    private MathTransform toResult(boolean isResultShifted) throws TransformException {
        if (isResultShifted) {
            if (this.shiftableToResult == null) {
                this.shiftableToResult = MathTransforms.concatenate(this.inputToShiftable.inverse(), this.inputToResult);
            }
            return this.shiftableToResult;
        }
        return this.inputToResult;
    }

    public GeneralEnvelope shift(Envelope areaOfInterest) throws TransformException {
        MathTransform toResult;
        boolean isResultShifted = false;
        if (this.initialize(areaOfInterest.getCoordinateReferenceSystem())) {
            DirectPosition upperCorner;
            DirectPosition lowerCorner;
            GeneralEnvelope shifted;
            if (this.inputToShiftable.isIdentity()) {
                shifted = null;
                lowerCorner = areaOfInterest.getLowerCorner();
                upperCorner = areaOfInterest.getUpperCorner();
            } else {
                shifted = Envelopes.transform(this.inputToShiftable, areaOfInterest);
                lowerCorner = shifted.getLowerCorner();
                upperCorner = shifted.getUpperCorner();
            }
            for (int i = 0; i < this.periods.length; ++i) {
                boolean upperIsAfter;
                double period = this.periods[i];
                if (!(period > 0.0)) continue;
                double lower = lowerCorner.getOrdinate(i);
                double upper = upperCorner.getOrdinate(i);
                double lowerCycles = 0.0;
                double upperCycles = 0.0;
                double delta = upper - lower;
                if (MathFunctions.isNegative(delta)) {
                    double cycles = delta == 0.0 ? -1.0 : Math.floor(delta / period);
                    if (Math.abs(lower + (delta = cycles * period)) < Math.abs(upper - delta)) {
                        lowerCycles = cycles;
                    } else {
                        upperCycles = -cycles;
                    }
                }
                double validStart = this.shiftableDomain.getMinimum(i);
                double validEnd = this.shiftableDomain.getMaximum(i);
                double lowerToValidStart = (validStart - lower) / period - lowerCycles;
                double upperToValidEnd = (validEnd - upper) / period - upperCycles;
                boolean lowerIsBefore = lowerToValidStart > 0.0;
                boolean bl = upperIsAfter = upperToValidEnd < 0.0;
                if (lowerIsBefore != upperIsAfter) {
                    double cycles;
                    double upperToValidStart = (validStart - upper) / period - upperCycles;
                    double lowerToValidEnd = (validEnd - lower) / period - lowerCycles;
                    if (lowerIsBefore) {
                        cycles = Math.min(Math.floor(lowerToValidEnd), Math.max(Math.floor(lowerToValidStart), Math.ceil(upperToValidStart)));
                        upperCycles = cycles + 1.0 < lowerToValidEnd ? (upperCycles += Math.ceil(upperToValidEnd)) : (upperCycles += cycles);
                        lowerCycles += cycles;
                    } else {
                        cycles = Math.max(Math.ceil(upperToValidStart), Math.min(Math.ceil(upperToValidEnd), Math.floor(lowerToValidEnd)));
                        lowerCycles = cycles - 1.0 > upperToValidStart ? (lowerCycles += Math.floor(lowerToValidStart)) : (lowerCycles += cycles);
                        upperCycles += cycles;
                    }
                }
                if (lowerCycles == 0.0 && upperCycles == 0.0) continue;
                isResultShifted = true;
                if (shifted == null) {
                    shifted = new GeneralEnvelope(areaOfInterest);
                }
                areaOfInterest = shifted;
                shifted.setRange(i, Math.fma(period, lowerCycles, lower), Math.fma(period, upperCycles, upper));
            }
        }
        if ((toResult = this.toResult(isResultShifted)) != null) {
            GeneralEnvelope result = Envelopes.transform(toResult, areaOfInterest);
            result.setCoordinateReferenceSystem(this.resultCRS);
            return result;
        }
        return GeneralEnvelope.castOrCopy(areaOfInterest);
    }

    public DirectPosition shift(DirectPosition pointOfInterest) throws TransformException {
        MathTransform toResult;
        boolean isResultShifted = false;
        if (this.initialize(pointOfInterest.getCoordinateReferenceSystem())) {
            DirectPosition shifted = this.inputToShiftable.isIdentity() ? pointOfInterest : this.inputToShiftable.transform(pointOfInterest, null);
            for (int i = 0; i < this.periods.length; ++i) {
                double period = this.periods[i];
                if (!(period > 0.0)) continue;
                double x = shifted.getOrdinate(i);
                double delta = this.shiftableDomain.getMinimum(i) - x;
                if (delta > 0.0) {
                    delta = Math.ceil(delta / period);
                } else {
                    delta = this.shiftableDomain.getMaximum(i) - x;
                    if (!(delta < 0.0)) continue;
                    delta = Math.floor(delta / period);
                }
                if (delta == 0.0) continue;
                isResultShifted = true;
                if (shifted == pointOfInterest) {
                    shifted = new GeneralDirectPosition(pointOfInterest);
                }
                pointOfInterest = shifted;
                shifted.setOrdinate(i, Math.fma(period, delta, x));
            }
        }
        if ((toResult = this.toResult(isResultShifted)) != null) {
            pointOfInterest = toResult.transform(pointOfInterest, this.resultCRS != null ? new GeneralDirectPosition(this.resultCRS) : null);
        }
        return pointOfInterest;
    }
}

