/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage;

import org.apache.sis.internal.coverage.CompoundTransform;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

final class CompoundTransformOf1D
extends CompoundTransform {
    private final MathTransform1D[] components;

    CompoundTransformOf1D(MathTransform1D[] components) {
        this.components = components;
    }

    @Override
    final MathTransform[] components() {
        return this.components;
    }

    @Override
    public int getSourceDimensions() {
        return this.components.length;
    }

    @Override
    public int getTargetDimensions() {
        return this.components.length;
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
        if (srcPts == dstPts && dstOff > srcOff) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, this.getSourceDimensions());
            srcPts = dstPts;
            srcOff = dstOff;
        }
        if (!derivate) {
            for (MathTransform1D c : this.components) {
                dstPts[dstOff++] = c.transform(srcPts[srcOff++]);
            }
            return null;
        }
        int n = this.components.length;
        MatrixSIS m4 = Matrices.createZero(n, n);
        for (int i = 0; i < n; ++i) {
            MathTransform1D c = this.components[i];
            double x = srcPts[srcOff++];
            dstPts[dstOff++] = c.transform(x);
            m4.setElement(i, i, c.derivative(x));
        }
        return m4;
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        int n = this.components.length;
        if (IterationStrategy.suggest(srcOff, n, dstOff, n, numPts) != IterationStrategy.ASCENDING) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * n);
            srcPts = dstPts;
            srcOff = dstOff;
        }
        while (--numPts >= 0) {
            for (MathTransform1D c : this.components) {
                dstPts[dstOff++] = c.transform(srcPts[srcOff++]);
            }
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        int n = this.components.length;
        if (IterationStrategy.suggest(srcOff, n, dstOff, n, numPts) != IterationStrategy.ASCENDING) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * n);
            srcPts = dstPts;
            srcOff = dstOff;
        }
        while (--numPts >= 0) {
            for (MathTransform1D c : this.components) {
                dstPts[dstOff++] = (float)c.transform(srcPts[srcOff++]);
            }
        }
    }

    @Override
    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        while (--numPts >= 0) {
            for (MathTransform1D c : this.components) {
                dstPts[dstOff++] = (float)c.transform(srcPts[srcOff++]);
            }
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        while (--numPts >= 0) {
            for (MathTransform1D c : this.components) {
                dstPts[dstOff++] = c.transform(srcPts[srcOff++]);
            }
        }
    }
}

