/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage;

import java.awt.image.ColorModel;
import java.awt.image.SampleModel;
import java.util.Arrays;
import java.util.List;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.internal.coverage.j2d.ColorModelFactory;
import org.apache.sis.internal.coverage.j2d.SampleModelFactory;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Localized;
import org.opengis.metadata.spatial.DimensionNameType;

public final class RangeArgument {
    private final long[] packed;
    public final boolean hasAllBands;
    private int first;
    private int last;
    private int interval;
    private SampleDimension.Builder builder;

    private RangeArgument(long[] packed, boolean hasAllBands) {
        this.packed = packed;
        this.hasAllBands = hasAllBands;
        this.interval = 1;
    }

    public static RangeArgument validate(int numSampleDimensions, int[] ranges, Localized listeners) {
        long[] packed;
        ArgumentChecks.ensureStrictlyPositive("numSampleDimensions", numSampleDimensions);
        if (ranges == null || ranges.length == 0) {
            packed = new long[numSampleDimensions];
            for (int i = 1; i < numSampleDimensions; ++i) {
                packed[i] = Numerics.tuple(i, i);
            }
        } else {
            packed = new long[ranges.length];
            for (int i = 0; i < ranges.length; ++i) {
                int r = ranges[i];
                if (r < 0 || r >= numSampleDimensions) {
                    throw new IllegalArgumentException(RangeArgument.resources(listeners).getString((short)86, numSampleDimensions - 1, r));
                }
                packed[i] = Numerics.tuple(r, i);
            }
            Arrays.sort(packed);
            int previous = -1;
            for (int i = 0; i < packed.length; ++i) {
                int r = (int)(packed[i] >>> 32);
                if (r == previous) {
                    throw new IllegalArgumentException(RangeArgument.resources(listeners).getString((short)85, r));
                }
                previous = r;
            }
        }
        return new RangeArgument(packed, packed.length == numSampleDimensions);
    }

    private static Resources resources(Localized listeners) {
        return Resources.forLocale(listeners != null ? listeners.getLocale() : null);
    }

    public boolean isIdentity() {
        if (!this.hasAllBands || this.interval != 1) {
            return false;
        }
        for (int i = 0; i < this.packed.length; ++i) {
            if (this.packed[i] == Numerics.tuple(i, i)) continue;
            return false;
        }
        return true;
    }

    public int getNumBands() {
        return this.packed.length;
    }

    public int[] getSelectedBands() {
        int[] bands = new int[this.getNumBands()];
        for (int i = 0; i < bands.length; ++i) {
            bands[this.getTargetIndex((int)i)] = this.getSourceIndex(i);
        }
        return bands;
    }

    public int getFirstSpecified() {
        for (long p : this.packed) {
            if ((int)p != 0) continue;
            return (int)(p >>> 32);
        }
        throw new IllegalStateException();
    }

    public int getSourceIndex(int i) {
        return (int)(this.packed[i] >>> 32);
    }

    public int getTargetIndex(int i) {
        return (int)this.packed[i];
    }

    public int getSubsampledIndex(int i) {
        return (this.getSourceIndex(i) - this.first) / this.interval;
    }

    public int getPixelStride() {
        return (this.last - this.first) / this.interval + 1;
    }

    public GridExtent insertBandDimension(GridExtent areaOfInterest, int bandDimension) {
        this.first = this.getSourceIndex(0);
        this.last = this.getSourceIndex(this.packed.length - 1);
        return areaOfInterest.insertDimension(bandDimension, DimensionNameType.valueOf("BAND"), this.first, this.last, true);
    }

    public int[] insertSubsampling(int[] subsampling, int bandDimension) {
        int[] delta = new int[this.packed.length - 1];
        for (int i = 0; i < delta.length; ++i) {
            delta[i] = this.getSourceIndex(i + 1) - this.getSourceIndex(i);
        }
        int[] divisors = MathFunctions.commonDivisors(delta);
        this.interval = divisors.length != 0 ? divisors[divisors.length - 1] : 1;
        subsampling = ArraysExt.insert(subsampling, bandDimension, 1);
        subsampling[bandDimension] = this.interval;
        return subsampling;
    }

    public SampleDimension[] select(List<? extends SampleDimension> sourceBands) {
        SampleDimension[] bands = new SampleDimension[this.getNumBands()];
        for (int i = 0; i < bands.length; ++i) {
            bands[this.getTargetIndex((int)i)] = sourceBands.get(this.getSourceIndex(i));
        }
        return bands;
    }

    public SampleModel select(SampleModel model, boolean view) {
        if (model == null || this.isIdentity()) {
            return model;
        }
        int[] bands = this.getSelectedBands();
        if (view) {
            return model.createSubsetSampleModel(bands);
        }
        SampleModelFactory factory = new SampleModelFactory(model);
        factory.subsetAndCompress(bands);
        return factory.build();
    }

    public ColorModel select(ColorModel colors) {
        if (colors == null || this.isIdentity()) {
            return colors;
        }
        return ColorModelFactory.createSubset(colors, this.getSelectedBands());
    }

    public SampleDimension.Builder builder() {
        if (this.builder == null) {
            this.builder = new SampleDimension.Builder();
        } else {
            this.builder.clear();
        }
        return this.builder;
    }
}

