/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage.j2d;

import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.sis.coverage.Category;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;

final class ColorsForRange
implements Comparable<ColorsForRange> {
    private CharSequence name;
    NumberRange<?> sampleRange;
    private final NumberRange<?> originalSampleRange;
    private final Color[] colors;
    private final ColorModel inheritedColors;
    final boolean isData;

    ColorsForRange(Category category, Function<Category, Color[]> colors, ColorModel inherited) {
        this.name = category.getName();
        this.sampleRange = category.getSampleRange();
        this.isData = category.isQuantitative();
        this.colors = colors.apply(category);
        this.inheritedColors = inherited;
        this.originalSampleRange = this.sampleRange;
    }

    ColorsForRange(CharSequence name, NumberRange<?> sampleRange, Color[] colors, boolean isData, ColorModel inherited) {
        ArgumentChecks.ensureNonNull("sampleRange", sampleRange);
        this.name = name;
        this.originalSampleRange = sampleRange;
        this.sampleRange = this.originalSampleRange;
        this.isData = isData;
        this.colors = colors;
        this.inheritedColors = inherited;
    }

    final boolean isUndefined() {
        return this.colors == null && this.inheritedColors == null;
    }

    static ColorsForRange[] list(Collection<Map.Entry<NumberRange<?>, Color[]>> colors, ColorModel inherited) {
        ArgumentChecks.ensureNonEmpty("colors", colors);
        ColorsForRange[] entries = new ColorsForRange[colors.size()];
        int n = 0;
        for (Map.Entry<NumberRange<?>, Color[]> entry : colors) {
            NumberRange<?> range = entry.getKey();
            boolean singleton = Objects.equals(range.getMinValue(), range.getMaxValue());
            entries[n++] = new ColorsForRange(null, range, entry.getValue(), !singleton, inherited);
        }
        return ArraysExt.resize(entries, n);
    }

    final CharSequence name() {
        if (this.name == null) {
            this.name = this.sampleRange.toString();
        }
        return this.name;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.name()).append(": ").append(this.sampleRange);
        ColorsForRange.appendColorRange(buffer, this.toARGB(2));
        return buffer.toString();
    }

    static void appendColorRange(StringBuilder buffer, int[] colors) {
        if (colors != null && colors.length != 0) {
            String s2 = " \u2192 ARGB[";
            int i = 0;
            do {
                buffer.append(s2).append(Integer.toHexString(colors[i]).toUpperCase());
                s2 = " \u2026 ";
            } while (i < (i = colors.length - 1));
            buffer.append(']');
        }
    }

    @Override
    public int compareTo(ColorsForRange other) {
        return this.getAlpha() - other.getAlpha();
    }

    private int getAlpha() {
        int max = 0;
        if (this.colors != null) {
            for (Color color : this.colors) {
                int alpha = color.getAlpha();
                if (alpha <= max) continue;
                if (alpha >= 255) {
                    return 255;
                }
                max = alpha;
            }
        } else if (this.isData) {
            return 255;
        }
        return max;
    }

    final int[] toARGB(int length) {
        if (this.colors != null) {
            int combined = 0;
            int[] ARGB = new int[this.colors.length];
            for (int i = 0; i < ARGB.length; ++i) {
                Color color = this.colors[i];
                if (color == null) continue;
                int c = color.getRGB();
                combined |= c;
                ARGB[i] = c;
            }
            if ((combined & 0xFF000000) != 0) {
                return ARGB;
            }
        } else {
            if (!this.originalSampleRange.isEmpty() && this.inheritedColors instanceof IndexColorModel) {
                int[] ARGB;
                IndexColorModel icm = (IndexColorModel)this.inheritedColors;
                int offset = Math.round((float)this.originalSampleRange.getMinDouble(true));
                int numSrc = Math.round((float)this.originalSampleRange.getMaxDouble()) - offset;
                if (this.originalSampleRange.isMinIncluded()) {
                    ++numSrc;
                }
                if (numSrc <= length) {
                    ARGB = new int[numSrc];
                    if (offset == 0 && numSrc == icm.getMapSize()) {
                        icm.getRGBs(ARGB);
                    } else {
                        for (int i = 0; i < numSrc; ++i) {
                            ARGB[i] = icm.getRGB(i + offset);
                        }
                    }
                } else {
                    ARGB = new int[length];
                    float scale = (float)(numSrc - 1) / (float)(length - 1);
                    for (int i = 0; i < length; ++i) {
                        ARGB[i] = icm.getRGB(Math.round((float)i * scale) + offset);
                    }
                }
                return ARGB;
            }
            if (this.isData) {
                return new int[]{-16777216, -1};
            }
        }
        return ArraysExt.EMPTY_INT;
    }
}

