/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import java.io.Serializable;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.internal.feature.InstantList;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.math.Vector;
import org.apache.sis.referencing.crs.DefaultTemporalCRS;
import org.apache.sis.util.iso.Names;
import org.opengis.feature.Attribute;
import org.opengis.feature.AttributeType;
import org.opengis.util.LocalName;
import org.opengis.util.ScopedName;

public class MovingFeatures {
    public static final AttributeType<Instant> TIME_AS_INSTANTS;
    private static final AttributeType<Number> TIME_AS_NUMBERS;
    private final Map<Vector, InstantList> cache;

    public static AttributeType<?> characteristic(boolean hasCRS) {
        return hasCRS ? TIME_AS_INSTANTS : TIME_AS_NUMBERS;
    }

    public MovingFeatures(MovingFeatures share) {
        this.cache = share != null ? share.cache : new HashMap<Vector, InstantList>();
    }

    public final void setInstants(Attribute<?> dest, long[] millis) {
        Attribute<Instant> c = TIME_AS_INSTANTS.newInstance();
        c.setValues(this.cache.computeIfAbsent(InstantList.vectorize(millis), InstantList::new));
        dest.characteristics().values().add(c);
    }

    public static void setTimes(Attribute<?> dest, Vector values, DefaultTemporalCRS converter) {
        Attribute<Serializable> ct;
        if (converter != null) {
            Instant[] instants = new Instant[values.size()];
            for (int i = 0; i < instants.length; ++i) {
                instants[i] = converter.toInstant(values.doubleValue(i));
            }
            Attribute<Instant> c = TIME_AS_INSTANTS.newInstance();
            c.setValues(UnmodifiableArrayList.wrap(instants));
            ct = c;
        } else {
            Attribute<Number> c = TIME_AS_NUMBERS.newInstance();
            c.setValues(values);
            ct = c;
        }
        dest.characteristics().values().add(ct);
    }

    static {
        LocalName scope = Names.createLocalName("OGC", null, "MF");
        Map<String, ScopedName> properties = Map.of("name", Names.createScopedName(scope, null, "datetimes"));
        TIME_AS_INSTANTS = new DefaultAttributeType<Object>(properties, Instant.class, 0, Integer.MAX_VALUE, null, new AttributeType[0]);
        TIME_AS_NUMBERS = new DefaultAttributeType<Object>(properties, Number.class, 0, Integer.MAX_VALUE, null, new AttributeType[0]);
    }
}

