/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.measure.Quantity;
import javax.measure.quantity.Length;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.filter.Visitor;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.filter.BetweenComparisonOperator;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.BinarySpatialOperator;
import org.opengis.filter.ComparisonOperatorName;
import org.opengis.filter.DistanceOperator;
import org.opengis.filter.DistanceOperatorName;
import org.opengis.filter.Expression;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.LikeOperator;
import org.opengis.filter.Literal;
import org.opengis.filter.LogicalOperator;
import org.opengis.filter.LogicalOperatorName;
import org.opengis.filter.MatchAction;
import org.opengis.filter.NilOperator;
import org.opengis.filter.NullOperator;
import org.opengis.filter.SpatialOperatorName;
import org.opengis.filter.TemporalOperator;
import org.opengis.filter.TemporalOperatorName;
import org.opengis.filter.ValueReference;
import org.opengis.geometry.Envelope;
import org.opengis.util.CodeList;

public class CopyVisitor<SR, TR, G, T>
extends Visitor<SR, List<Object>> {
    protected final FilterFactory<TR, G, T> factory;
    private final boolean forceNew;
    private final boolean forceUse;

    public CopyVisitor(FilterFactory<TR, G, T> factory, boolean force) {
        this(factory, true, force);
    }

    CopyVisitor(FilterFactory<TR, G, T> newFactory, boolean forceNew, boolean forceUse) {
        ArgumentChecks.ensureNonNull("factory", newFactory);
        this.factory = newFactory;
        this.forceNew = forceNew;
        this.forceUse = forceUse;
        this.setCopyHandler(ComparisonOperatorName.PROPERTY_IS_EQUAL_TO, FilterFactory::equal);
        this.setCopyHandler(ComparisonOperatorName.PROPERTY_IS_NOT_EQUAL_TO, FilterFactory::notEqual);
        this.setCopyHandler(ComparisonOperatorName.PROPERTY_IS_LESS_THAN, FilterFactory::less);
        this.setCopyHandler(ComparisonOperatorName.PROPERTY_IS_GREATER_THAN, FilterFactory::greater);
        this.setCopyHandler(ComparisonOperatorName.PROPERTY_IS_LESS_THAN_OR_EQUAL_TO, FilterFactory::lessOrEqual);
        this.setCopyHandler(ComparisonOperatorName.PROPERTY_IS_GREATER_THAN_OR_EQUAL_TO, FilterFactory::greaterOrEqual);
        this.setCopyHandler(TemporalOperatorName.AFTER, FilterFactory::after);
        this.setCopyHandler(TemporalOperatorName.BEFORE, FilterFactory::before);
        this.setCopyHandler(TemporalOperatorName.BEGINS, FilterFactory::begins);
        this.setCopyHandler(TemporalOperatorName.BEGUN_BY, FilterFactory::begunBy);
        this.setCopyHandler(TemporalOperatorName.CONTAINS, FilterFactory::tcontains);
        this.setCopyHandler(TemporalOperatorName.DURING, FilterFactory::during);
        this.setCopyHandler(TemporalOperatorName.EQUALS, FilterFactory::tequals);
        this.setCopyHandler(TemporalOperatorName.OVERLAPS, FilterFactory::toverlaps);
        this.setCopyHandler(TemporalOperatorName.MEETS, FilterFactory::meets);
        this.setCopyHandler(TemporalOperatorName.ENDS, FilterFactory::ends);
        this.setCopyHandler(TemporalOperatorName.OVERLAPPED_BY, FilterFactory::overlappedBy);
        this.setCopyHandler(TemporalOperatorName.MET_BY, FilterFactory::metBy);
        this.setCopyHandler(TemporalOperatorName.ENDED_BY, FilterFactory::endedBy);
        this.setCopyHandler(TemporalOperatorName.ANY_INTERACTS, FilterFactory::anyInteracts);
        this.setCopyHandler(SpatialOperatorName.BBOX, SpatialFactory::bbox);
        this.setCopyHandler(SpatialOperatorName.EQUALS, FilterFactory::equals);
        this.setCopyHandler(SpatialOperatorName.DISJOINT, FilterFactory::disjoint);
        this.setCopyHandler(SpatialOperatorName.INTERSECTS, FilterFactory::intersects);
        this.setCopyHandler(SpatialOperatorName.TOUCHES, FilterFactory::touches);
        this.setCopyHandler(SpatialOperatorName.CROSSES, FilterFactory::crosses);
        this.setCopyHandler(SpatialOperatorName.WITHIN, FilterFactory::within);
        this.setCopyHandler(SpatialOperatorName.CONTAINS, FilterFactory::contains);
        this.setCopyHandler(SpatialOperatorName.OVERLAPS, FilterFactory::overlaps);
        this.setCopyHandler(DistanceOperatorName.WITHIN, FilterFactory::within);
        this.setCopyHandler(DistanceOperatorName.BEYOND, FilterFactory::beyond);
        this.setCopyHandler(LogicalOperatorName.AND, FilterFactory::and);
        this.setCopyHandler(LogicalOperatorName.OR, FilterFactory::or);
        this.setCopyHandler(LogicalOperatorName.NOT, LogicalFactory::not);
        this.setCopyHandler("Add", FilterFactory::add);
        this.setCopyHandler("Subtract", FilterFactory::subtract);
        this.setCopyHandler("Multiply", FilterFactory::multiply);
        this.setCopyHandler("Divide", FilterFactory::divide);
        this.setFilterHandler(ComparisonOperatorName.valueOf("PROPERTY_IS_BETWEEN"), (filter, accumulator) -> {
            BetweenComparisonOperator<TR> target = null;
            BetweenComparisonOperator source = (BetweenComparisonOperator)filter;
            List exps = this.copyExpressions(source.getExpressions());
            if (exps != null && exps.size() == 2) {
                target = this.factory.between(exps.get(0), exps.get(1), exps.get(2));
            }
            this.accept((List<Object>)accumulator, source, target);
        });
        this.setFilterHandler(ComparisonOperatorName.valueOf("PROPERTY_IS_LIKE"), (filter, accumulator) -> {
            Object literal;
            Expression p2;
            LikeOperator<TR> target = null;
            LikeOperator source = (LikeOperator)filter;
            List exps = this.copyExpressions(source.getExpressions());
            if (exps != null && exps.size() == 2 && (p2 = exps.get(1)) instanceof Literal && (literal = ((Literal)p2).getValue()) instanceof String) {
                target = this.factory.like(exps.get(0), (String)literal, source.getWildCard(), source.getSingleChar(), source.getEscapeChar(), source.isMatchingCase());
            }
            this.accept((List<Object>)accumulator, source, target);
        });
        this.setFilterHandler(ComparisonOperatorName.valueOf("PROPERTY_IS_NIL"), (filter, accumulator) -> {
            NilOperator<TR> target = null;
            NilOperator source = (NilOperator)filter;
            List exps = this.copyExpressions(source.getExpressions());
            if (exps != null && exps.size() == 1) {
                target = this.factory.isNil(exps.get(0), source.getNilReason().orElse(null));
            }
            this.accept((List<Object>)accumulator, source, target);
        });
        this.setFilterHandler(ComparisonOperatorName.valueOf("PROPERTY_IS_NULL"), (filter, accumulator) -> {
            NullOperator<TR> target = null;
            NullOperator source = (NullOperator)filter;
            List exps = this.copyExpressions(source.getExpressions());
            if (exps != null && exps.size() == 1) {
                target = this.factory.isNull(exps.get(0));
            }
            this.accept((List<Object>)accumulator, source, target);
        });
        this.setExpressionHandler("Literal", (expression, accumulator) -> {
            Literal source = (Literal)expression;
            Literal target = this.factory.literal(source.getValue());
            this.accept((List<Object>)accumulator, source, target);
        });
        this.setExpressionHandler("ValueReference", (expression, accumulator) -> {
            ValueReference source = (ValueReference)expression;
            ValueReference<TR, ?> target = this.factory.property(source.getXPath());
            this.accept((List<Object>)accumulator, source, target);
        });
    }

    protected final void setCopyHandler(ComparisonOperatorName type, BinaryComparisonFactory<TR> action) {
        this.setFilterHandler(type, (filter, accumulator) -> {
            BinaryComparisonOperator<TR> target = null;
            BinaryComparisonOperator source = (BinaryComparisonOperator)filter;
            List exps = this.copyExpressions(source.getExpressions());
            if (exps != null && exps.size() == 2) {
                target = action.create(this.factory, exps.get(0), exps.get(1), source.isMatchingCase(), source.getMatchAction());
            }
            this.accept((List<Object>)accumulator, source, target);
        });
    }

    protected final void setCopyHandler(TemporalOperatorName type, TemporalFactory<TR, T> action) {
        this.setFilterHandler(type, (filter, accumulator) -> {
            TemporalOperator<TR> target = null;
            TemporalOperator source = (TemporalOperator)filter;
            List exps = this.copyExpressions(source.getExpressions());
            if (exps != null && exps.size() == 2) {
                target = action.create(this.factory, exps.get(0), exps.get(1));
            }
            this.accept((List<Object>)accumulator, source, target);
        });
    }

    protected final void setCopyHandler(SpatialOperatorName type, SpatialFactory<TR, G> action) {
        this.setFilterHandler(type, (filter, accumulator) -> {
            BinarySpatialOperator<TR> target = null;
            BinarySpatialOperator source = (BinarySpatialOperator)filter;
            List exps = this.copyExpressions(source.getExpressions());
            if (exps != null && exps.size() == 2) {
                target = action.create(this.factory, exps.get(0), exps.get(1));
            }
            this.accept((List<Object>)accumulator, source, target);
        });
    }

    protected final void setCopyHandler(DistanceOperatorName type, DistanceFactory<TR, G> action) {
        this.setFilterHandler(type, (filter, accumulator) -> {
            DistanceOperator<TR> target = null;
            DistanceOperator source = (DistanceOperator)filter;
            List exps = this.copyExpressions(source.getExpressions());
            if (exps != null && exps.size() == 3) {
                target = action.create(this.factory, exps.get(0), exps.get(1), source.getDistance());
            }
            this.accept((List<Object>)accumulator, source, target);
        });
    }

    protected final void setCopyHandler(LogicalOperatorName type, LogicalFactory<TR> action) {
        this.setFilterHandler(type, (filter, accumulator) -> {
            LogicalOperator<TR> target = null;
            LogicalOperator source = (LogicalOperator)filter;
            List<Filter<TR>> exps = this.copyFilters(source.getOperands());
            if (exps != null) {
                target = action.create(this.factory, exps);
            }
            this.accept((List<Object>)accumulator, source, target);
        });
    }

    protected final void setCopyHandler(String name, BinaryFunctionFactory<TR> action) {
        this.setExpressionHandler(name, (source, accumulator) -> {
            Expression<TR, Number> target = null;
            List exps = this.copyExpressions(source.getParameters());
            if (exps != null) {
                target = action.create(this.factory, exps.get(0), exps.get(1));
            }
            this.accept((List<Object>)accumulator, source, target);
        });
    }

    private void accept(List<Object> accumulator, Object source, Object target) {
        if (target == null) {
            if (this.forceNew) {
                throw new IllegalArgumentException(Errors.format((short)169, source));
            }
            target = source;
        } else if (!this.forceUse && target.equals(source)) {
            target = source;
        }
        accumulator.add(target);
    }

    private <V> List<Expression<TR, V>> copyExpressions(List<Expression<SR, ?>> source) {
        ArrayList<Expression<TR, V>> results = new ArrayList<Expression<TR, V>>(source.size());
        for (Expression<SR, ?> e : source) {
            this.visit(e, results);
        }
        return !this.forceNew && results.equals(source) ? null : results;
    }

    private List<Filter<TR>> copyFilters(List<Filter<SR>> source) {
        ArrayList<Filter<TR>> results = new ArrayList<Filter<TR>>(source.size());
        for (Filter<SR> e : source) {
            this.visit(e, results);
        }
        return !this.forceNew && results.equals(source) ? null : results;
    }

    public Filter<TR> copy(Filter<SR> source) {
        ArrayList accumulator = new ArrayList(1);
        this.visit(source, accumulator);
        switch (accumulator.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Filter)accumulator.get(0);
            }
        }
        throw new AssertionError(accumulator);
    }

    public <V> Expression<TR, V> copy(Expression<SR, V> source) {
        ArrayList accumulator = new ArrayList(1);
        this.visit(source, accumulator);
        switch (accumulator.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Expression)accumulator.get(0);
            }
        }
        throw new AssertionError(accumulator);
    }

    @Override
    protected void typeNotFound(CodeList<?> type, Filter<SR> filter, List<Object> accumulator) {
        if (this.forceNew) {
            throw new IllegalArgumentException(Resources.format((short)77, 0, type));
        }
        accumulator.add(filter);
    }

    @Override
    protected void typeNotFound(String name, Expression<SR, ?> expression, List<Object> accumulator) {
        List exps = this.copyExpressions(expression.getParameters());
        if (exps != null) {
            expression = this.factory.function(name, (Expression[])exps.toArray(Expression[]::new));
        }
        accumulator.add(expression);
    }

    @FunctionalInterface
    protected static interface BinaryComparisonFactory<R> {
        public BinaryComparisonOperator<R> create(FilterFactory<R, ?, ?> var1, Expression<R, ?> var2, Expression<R, ?> var3, boolean var4, MatchAction var5);
    }

    @FunctionalInterface
    protected static interface TemporalFactory<R, T> {
        public TemporalOperator<R> create(FilterFactory<R, ?, T> var1, Expression<R, ? extends T> var2, Expression<R, ? extends T> var3);
    }

    @FunctionalInterface
    protected static interface SpatialFactory<R, G> {
        public BinarySpatialOperator<R> create(FilterFactory<R, G, ?> var1, Expression<R, ? extends G> var2, Expression<R, ? extends G> var3);

        public static <R, G> BinarySpatialOperator<R> bbox(FilterFactory<R, G, ?> factory, Expression<R, ? extends G> geometry1, Expression<R, ? extends G> geometry2) {
            Object bounds;
            if (geometry2 instanceof Literal && (bounds = ((Literal)geometry2).getValue()) instanceof Envelope) {
                return factory.bbox(geometry1, (Envelope)bounds);
            }
            return null;
        }
    }

    @FunctionalInterface
    protected static interface DistanceFactory<R, G> {
        public DistanceOperator<R> create(FilterFactory<R, G, ?> var1, Expression<R, ? extends G> var2, Expression<R, ? extends G> var3, Quantity<Length> var4);
    }

    @FunctionalInterface
    protected static interface LogicalFactory<R> {
        public LogicalOperator<R> create(FilterFactory<R, ?, ?> var1, Collection<? extends Filter<R>> var2);

        public static <R> LogicalOperator<R> not(FilterFactory<R, ?, ?> factory, Collection<? extends Filter<R>> operands) {
            Filter<R> op = CollectionsExt.singletonOrNull(operands);
            return op != null ? factory.not(op) : null;
        }
    }

    @FunctionalInterface
    protected static interface BinaryFunctionFactory<R> {
        public Expression<R, Number> create(FilterFactory<R, ?, ?> var1, Expression<R, ? extends Number> var2, Expression<R, ? extends Number> var3);
    }
}

