/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.filter.sqlmm;

import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.filter.sqlmm.GeometryConstructor;
import org.apache.sis.internal.filter.sqlmm.SQLMM;
import org.apache.sis.util.resources.Errors;
import org.opengis.filter.Expression;
import org.opengis.filter.InvalidFilterValueException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

abstract class GeometryParser<R, G>
extends GeometryConstructor<R, G> {
    private static final long serialVersionUID = -4636578226555118315L;

    GeometryParser(SQLMM operation, Expression<R, ?>[] parameters, Geometries<G> library) {
        super(operation, parameters, library);
    }

    @Override
    public abstract Expression<R, Object> recreate(Expression<R, ?>[] var1);

    @Override
    public final String getSyntax() {
        return String.valueOf(this.getFunctionName().tip()) + " ( <" + this.inputName() + "> [, <srid>] )";
    }

    abstract String inputName();

    @Override
    public final Object apply(R input) {
        Object value = this.geometry.apply(input);
        try {
            CoordinateReferenceSystem crs;
            GeometryWrapper<G> parsed = this.parse(value);
            if (parsed == null) {
                return null;
            }
            GeometryWrapper<G> result = parsed.toGeometryType(this.operation.getGeometryType().get());
            if (result != parsed) {
                switch (this.operation) {
                    case ST_BdPolyFromWKB: 
                    case ST_BdPolyFromText: 
                    case ST_BdMPolyFromWKB: 
                    case ST_BdMPolyFromText: {
                        break;
                    }
                    default: {
                        this.warning(new InvalidFilterValueException(Errors.format((short)43, this.inputName(), this.getValueClass(), result.implementation().getClass())), true);
                    }
                }
            }
            if (this.srid != null && (crs = this.getTargetCRS(input)) != null) {
                result.setCoordinateReferenceSystem(crs);
            }
            return result.implementation();
        }
        catch (Exception e) {
            this.warning(e, false);
            return null;
        }
    }

    protected abstract GeometryWrapper<G> parse(Object var1) throws Exception;
}

