/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.metadata.replace;

import java.util.Objects;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.simple.SimpleIdentifiedObject;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.util.TypeName;

abstract class Parameter<T>
extends SimpleIdentifiedObject
implements ParameterDescriptor<T> {
    private volatile transient ParameterDescriptor<T> descriptor;

    Parameter() {
    }

    Parameter(ParameterDescriptor<T> parameter) {
        super(parameter);
        this.descriptor = parameter;
    }

    @Override
    public TypeName getValueType() {
        ParameterDescriptor<T> p = this.descriptor;
        return p != null ? p.getValueType() : null;
    }

    @Override
    public Class<T> getValueClass() {
        ParameterDescriptor<T> p = this.descriptor;
        return p != null ? p.getValueClass() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ParameterValue<T> createValue() {
        ParameterDescriptor<T> p;
        Parameter parameter = this;
        synchronized (parameter) {
            p = this.descriptor;
            if (p == null) {
                p = ReferencingServices.getInstance().toImplementation(this);
                this.descriptor = p;
            }
        }
        return p.createValue();
    }

    @Override
    public final boolean equals(Object object, ComparisonMode mode) {
        ParameterDescriptor that;
        if (object == this) {
            return true;
        }
        if (super.equals(object, mode) && object instanceof ParameterDescriptor && (that = (ParameterDescriptor)object).getUnit() == null && that.getDefaultValue() == null && that.getValueClass() == this.getValueClass()) {
            if (mode.isIgnoringMetadata()) {
                return Objects.equals(Parameter.toString(this.getName()), Parameter.toString(that.getName()));
            }
            return Utilities.deepEquals(that.getValueType(), this.getValueType(), mode) && Utilities.deepEquals(that.getDescription(), this.getDescription(), mode) && that.getDirection() == this.getDirection() && that.getMinimumOccurs() == this.getMinimumOccurs() && that.getMaximumOccurs() == this.getMaximumOccurs() && that.getValidValues() == null && that.getMinimumValue() == null && that.getMaximumValue() == null;
        }
        return false;
    }

    private static String toString(Identifier identifier) {
        return identifier != null ? identifier.toString() : null;
    }
}

