/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.referencing;

import jakarta.xml.bind.annotation.XmlElement;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.measure.Unit;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.gco.PropertyType;
import org.apache.sis.internal.jaxb.referencing.CC_GeneralOperationParameter;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.internal.referencing.provider.MapProjection;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.parameter.DefaultParameterValue;
import org.apache.sis.parameter.DefaultParameterValueGroup;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.util.ArraysExt;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public final class CC_OperationMethod
extends PropertyType<CC_OperationMethod, OperationMethod> {
    public CC_OperationMethod() {
    }

    @Override
    protected Class<OperationMethod> getBoundType() {
        return OperationMethod.class;
    }

    private CC_OperationMethod(OperationMethod method) {
        super(method);
    }

    @Override
    protected CC_OperationMethod wrap(OperationMethod method) {
        return new CC_OperationMethod(method);
    }

    @XmlElement(name="OperationMethod")
    public DefaultOperationMethod getElement() {
        return DefaultOperationMethod.castOrCopy((OperationMethod)this.metadata);
    }

    public void setElement(DefaultOperationMethod method) {
        this.metadata = method;
        CC_GeneralOperationParameter.validate(method.getParameters(), "OperationMethod", "parameter");
    }

    public static GeneralParameterValue[] filterImplicit(GeneralParameterValue[] array) {
        int n = 0;
        for (GeneralParameterValue value : array) {
            if (CC_OperationMethod.isImplicitParameter(value.getDescriptor())) continue;
            array[n++] = value;
        }
        return ArraysExt.resize(array, n);
    }

    public static GeneralParameterDescriptor[] filterImplicit(GeneralParameterDescriptor[] array) {
        int n = 0;
        for (GeneralParameterDescriptor descriptor : array) {
            if (CC_OperationMethod.isImplicitParameter(descriptor)) continue;
            array[n++] = descriptor;
        }
        return ArraysExt.resize(array, n);
    }

    static boolean isImplicitParameter(GeneralParameterDescriptor descriptor) {
        return descriptor == MapProjection.SEMI_MAJOR || descriptor == MapProjection.SEMI_MINOR;
    }

    public static ParameterDescriptorGroup group(Identifier name, GeneralParameterDescriptor[] descriptors) {
        OperationMethod method;
        try {
            method = CoordinateOperations.factory().getOperationMethod(name.getCode());
        }
        catch (FactoryException e) {
            Context.warningOccured(Context.current(), DefaultOperationMethod.class, "setDescriptors", e, true);
            method = null;
        }
        Map<String, Identifier> properties = Map.of("name", name);
        if (method != null) {
            ParameterDescriptorGroup parameters = method.getParameters();
            return CC_GeneralOperationParameter.merge(DefaultOperationMethod.class, properties, IdentifiedObjects.getProperties(parameters, new String[0]), 1, 1, descriptors, parameters, true);
        }
        return new DefaultParameterDescriptorGroup(properties, 1, 1, descriptors);
    }

    /*
     * WARNING - void declaration
     */
    public static void store(GeneralParameterValue[] parameters, Collection<GeneralParameterValue> addTo, Map<GeneralParameterDescriptor, GeneralParameterDescriptor> replacements) {
        for (GeneralParameterValue generalParameterValue : parameters) {
            void var6_6;
            GeneralParameterDescriptor replacement = replacements.get(generalParameterValue.getDescriptor());
            if (replacement != null) {
                Cloneable target;
                GeneralParameterValue source;
                if (generalParameterValue instanceof ParameterValue) {
                    source = (ParameterValue)generalParameterValue;
                    target = new DefaultParameterValue((ParameterDescriptor)replacement);
                    Object value = source.getValue();
                    Unit<?> unit = source.getUnit();
                    if (unit == null) {
                        target.setValue(value);
                    } else if (value instanceof double[]) {
                        target.setValue((double[])value, unit);
                    } else {
                        target.setValue(((Number)value).doubleValue(), unit);
                    }
                    Cloneable cloneable = target;
                } else if (generalParameterValue instanceof ParameterValueGroup) {
                    source = (ParameterValueGroup)generalParameterValue;
                    target = new DefaultParameterValueGroup((ParameterDescriptorGroup)replacement);
                    List<GeneralParameterValue> values = source.values();
                    CC_OperationMethod.store((GeneralParameterValue[])values.toArray(GeneralParameterValue[]::new), target.values(), replacements);
                    Cloneable cloneable = target;
                }
            }
            addTo.add((GeneralParameterValue)var6_6);
        }
    }
}

