/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.processing.isoline;

import org.apache.sis.internal.feature.j2d.PathBuilder;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

final class Joiner
extends PathBuilder {
    private final MathTransform gridToCRS;

    Joiner(MathTransform gridToCRS) {
        this.gridToCRS = gridToCRS;
    }

    @Override
    protected int filterChunk(double[] coordinates, int lower, int upper) {
        int base;
        int spike0 = lower;
        int spike1 = lower;
        if (spike1 < upper) {
            double xo = coordinates[spike1++];
            double yo = coordinates[spike1++];
            int equalityMask = 3;
            while (spike1 < upper) {
                int before = equalityMask;
                if (coordinates[spike1++] != xo) {
                    equalityMask &= 0xFFFFFFFE;
                }
                if (coordinates[spike1++] != yo) {
                    equalityMask &= 0xFFFFFFFD;
                }
                if (equalityMask != 0) continue;
                equalityMask = before;
                spike1 -= 2;
                break;
            }
            while (spike0 > 0) {
                if (coordinates[--spike0] != yo) {
                    equalityMask &= 0xFFFFFFFD;
                }
                if (coordinates[--spike0] != xo) {
                    equalityMask &= 0xFFFFFFFE;
                }
                if (equalityMask != 0) continue;
                spike0 += 2;
                break;
            }
        }
        int limit = spike1;
        while ((base = spike0 + 4) < limit) {
            double xo = coordinates[spike0++];
            double yo = coordinates[spike0++];
            spike1 = limit;
            do {
                if (coordinates[spike1 - 2] != xo || coordinates[spike1 - 1] != yo) continue;
                System.arraycopy(coordinates, spike1, coordinates, spike0, upper - spike1);
                return upper - (spike1 - spike0);
            } while ((spike1 -= 2) > base);
        }
        return upper;
    }

    @Override
    protected int filterFull(double[] coordinates, int upper) throws TransformException {
        if (this.gridToCRS != null) {
            this.gridToCRS.transform(coordinates, 0, coordinates, 0, upper / 2);
        }
        return upper;
    }
}

