/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.provider.AlbersEqualArea;
import org.apache.sis.internal.referencing.provider.Equirectangular;
import org.apache.sis.internal.referencing.provider.MapProjection;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.operation.PlanarProjection;

@XmlTransient
public class LambertAzimuthalEqualArea
extends MapProjection {
    private static final long serialVersionUID = 3360095493388421774L;
    public static final String IDENTIFIER_OF_BASE = "9820";
    public static final ParameterDescriptor<Double> LATITUDE_OF_ORIGIN;
    public static final ParameterDescriptor<Double> LONGITUDE_OF_ORIGIN;
    public static final ParameterDescriptor<Double> FALSE_EASTING;
    public static final ParameterDescriptor<Double> FALSE_NORTHING;
    private static final ParameterDescriptorGroup PARAMETERS;

    public LambertAzimuthalEqualArea() {
        this(PARAMETERS);
    }

    LambertAzimuthalEqualArea(ParameterDescriptorGroup parameters) {
        super(PlanarProjection.class, parameters);
    }

    @Override
    protected final NormalizedProjection createProjection(Parameters parameters) {
        return new org.apache.sis.referencing.operation.projection.LambertAzimuthalEqualArea(this, parameters);
    }

    static {
        FALSE_EASTING = Equirectangular.FALSE_EASTING;
        FALSE_NORTHING = Equirectangular.FALSE_NORTHING;
        ParameterBuilder builder = LambertAzimuthalEqualArea.builder();
        LATITUDE_OF_ORIGIN = LambertAzimuthalEqualArea.createLatitude(LambertAzimuthalEqualArea.renameAlias(builder, Equirectangular.LATITUDE_OF_ORIGIN, Citations.OGC, AlbersEqualArea.LATITUDE_OF_FALSE_ORIGIN), true);
        LONGITUDE_OF_ORIGIN = LambertAzimuthalEqualArea.createLongitude(LambertAzimuthalEqualArea.renameAlias(builder, Equirectangular.LONGITUDE_OF_ORIGIN, Citations.OGC, AlbersEqualArea.LONGITUDE_OF_FALSE_ORIGIN));
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addIdentifier(IDENTIFIER_OF_BASE)).addName("Lambert Azimuthal Equal Area")).addName(Citations.OGC, "Lambert_Azimuthal_Equal_Area")).addName(Citations.ESRI, "Lambert_Azimuthal_Equal_Area")).addName(Citations.NETCDF, "LambertAzimuthalEqualArea")).addName(Citations.GEOTIFF, "CT_LambertAzimEqualArea")).addName(Citations.PROJ4, "laea")).addIdentifier(Citations.GEOTIFF, "10")).addIdentifier(Citations.MAP_INFO, "4")).createGroupForMapProjection(LATITUDE_OF_ORIGIN, LONGITUDE_OF_ORIGIN, FALSE_EASTING, FALSE_NORTHING);
    }
}

