/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.simple;

import java.io.Serializable;
import org.opengis.feature.Attribute;
import org.opengis.feature.AttributeType;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.Type;
import org.opengis.util.TypeName;

public final class SimpleAttributeType<V>
implements AttributeType<V>,
Type,
Serializable {
    private static final long serialVersionUID = -4130729627352535488L;
    private final TypeName name;
    private final Class<V> valueClass;

    public SimpleAttributeType(TypeName name, Class<V> valueClass) {
        this.name = name;
        this.valueClass = valueClass;
    }

    @Override
    public GenericName getName() {
        return this.name;
    }

    @Override
    public TypeName getTypeName() {
        return this.name;
    }

    @Override
    public Class<V> getValueClass() {
        return this.valueClass;
    }

    @Override
    public int getMinimumOccurs() {
        return 1;
    }

    @Override
    public int getMaximumOccurs() {
        return 1;
    }

    @Override
    public V getDefaultValue() {
        return null;
    }

    @Override
    public InternationalString getDefinition() {
        return null;
    }

    @Override
    public Attribute<V> newInstance() {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.valueClass.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SimpleAttributeType) {
            SimpleAttributeType other = (SimpleAttributeType)object;
            return this.name.equals(other.name) && this.valueClass.equals(other.valueClass);
        }
        return false;
    }

    public String toString() {
        return this.name.toFullyQualifiedName().toString();
    }
}

